   ; NOISE_STD

   ; OPT_HISTO: auxiliary procedure. Compute the optimal histogram
   ; by adjusting iteratively the bin size so that the HWHM of the
   ; histogram itself contains at least a minimum number of bins.

   PRO opt_histo, data, x, h

	half = 0.5		; relative cut to find the histogram HWHM
	min_n_half = 3	; min no. of bins in histogram HWHM
	max_nbin = 1000	; max no. of histogram bins
	range = float( max( [ abs(min(data)), abs(max(data)) ] ) )
	dmin = -range  &  dmax = +range  &  range = 2*range  &  bin = range
	; compute the histogram, adjusting iteratively the bin size
	repeat begin
	   ; reduce bin size
	   bin = bin / 2  &  nbin = range / bin
	   ; compute histogram
	   histo, data, dmin, dmax, bin, x, h
	   ; find left HWHM of histogram
	   s = reverse( sort( h ) )  &  threshold = half * h[s[1]]
	   l = s[1]  &  while  h[l] gt threshold and l gt 0  do  l = l - 1
	   l = l > 0  &  n_half = s[0] - l + 1
	endrep until  n_half gt 3 or nbin ge max_nbin
	return
   end



   FUNCTION gaussian_noise_std, data, PATCH = patch, $
   								N_STD = n_std, i, h, hfit

	; remove median
	if  n_elements( patch ) eq 0  then  patch = 3
	residual = data - median_filter( data, patch )
	; clip data
	if  n_elements( n_std ) eq 0  then  n_std = 3
	med = median( residual )
	range = n_std * sqrt( ( moment( residual - med ) )[1] )
	w = where( residual gt med - range and residual lt med + range, count )
	if  count eq 0  then  return, -1
	residual = residual[w]
	; compute histogram with suitable bin size
	opt_histo, residual, i, h
	; gaussian fit to histogram
	hfit = gaussfit( i, h, NTERMS = 3, c )
	return, c[2]
   end