   ; NOISE_VAR: given a set of data affected by uniform and photon
   ; noise, estimate the overall noise variance for each pixel.
   ; By uniform noise we mean all the noise sources which have the
   ; same distribution over the while data frame, e.g. read-out-noise,
   ; dark current, thermal background. The noise sources may have
   ; different statistical distributions (read-out-noise is gaussian,
   ; dark current and thermal background are poissonian): the main
   ; point is the possibility to associate the same standard deviation
   ; to all the pixels in the frame.
   ; By photon noise we mean the Poisson noise on counts from objects
   ; in the sky (stars, extended objects, nebulosities, sky, etc.). Its
   ; standard deviation is estimated by the square root of the signal.

   ; INPUT
   ;	sigma: total standard deviation of 'uniform' noise in ADU/pixel
   ;	counts: scalar or array, number of counts from the target
   ;		(including stars, sky and any other astronomical source),
   ;		expressed in ADU/pixel
   ; OUTPUT
   ;	Return noise variance in ADU/pixel for every pixel in the
   ;	input array of counts

   FUNCTION noise_var, sigma, counts

	return, sigma^2 + ( counts > 0 )
   end