   ; PHASE: Compute the (sx * sy) phase array corresponding to a
   ;	delta-function at (x,y).

   ; INPUT
   ;	x, y: position of delta-function (not necessarily integer)
   ;	sx, sy: x- and y- sizes of phase array
   ;	[/DOUBLE_P]: if set, the phase array is in double precision
   ; OUTPUT
   ;	Return phase array

   FUNCTION phase, x, y, sx, sy, DOUBLE_P = double_p

	if  keyword_set( double_p )  then  pi = !Dpi  else  pi = !pi
	arg = frequency( sx ) * 2 * pi / sx
	arg_u = arg * x
	if  sy ne sx  then  arg = frequency( sy ) * 2 * pi / sy
	arg_v = arg * y
	if  keyword_set( double_p )  then begin
	   uphase = dcomplex( cos(arg_u),-sin(arg_u) )
	   vphase = dcomplex( cos(arg_v),-sin(arg_v) )
	endif else begin
	   uphase =  complex( cos(arg_u),-sin(arg_u) )
	   vphase =  complex( cos(arg_v),-sin(arg_v) )
	endelse
	return, uphase # vphase
   end
