   ; PLANE: compute a slanting plane, defined as
   ;	plane(x,y) = c + cx * x + cy * y,
   ;	for x = 0, ..., sx - 1 and y = 0, ..., sy - 1.

   ; INPUT
   ;	c, cx, cy: constant term, x- and y- gradients
   ;	sx: x- size of the plane
   ;	[sy]: y- size of the plane (default = sx)
   ; OUTPUT
   ;	Return a sx * sy floating point array, containing the slanting plane

   FUNCTION plane, c, cx, cy, sx, sy

	if  n_params() eq 4  then  sy = sx
	x = findgen( sx ) # ( fltarr( sy ) + 1 )
	y = ( fltarr( sx ) + 1 ) # findgen( sy )
	return, c + cx * x + cy * y
   end