;procedure to plot an image with circle at the detected positions x,y.

PRO plotcircle,image,x,y,mag,windownumber,plot=plot,wsize=wsize,id=id


if N_params() LT 3 then begin
	print,'Syntax: plotcircle,image,x,y,mag[,windownumber][,plot]'
	return
endif

if N_params() LT 5 then windownumber=9
if NOT keyword_set(plot) then plot=[min(image),max(image)] 
if NOT keyword_set(wsize) then wsize=n_elements(image(*,0))
;yarraysize=n_elements(image(0,*))
xarraysize=float(n_elements(image(*,0)))
window,windownumber,title='image with cicle',xsize=wsize,ysize=wsize
tvscl,congrid(image>(plot(0))<plot(1),wsize,wsize)

starnumber=N_elements(x)
a=findgen(45)*2*!PI/45.
usersym,cos(a),sin(a)
for i=0,starnumber-1 do plots,x(i)*wsize/xarraysize,y(i)*wsize/xarraysize,psym=8,symsize=(max(mag)-mag(i))/3+0.5,/device

if keyword_set(ID) then for i=0,starnumber-1 do xyouts,x(i)*wsize/xarraysize,y(i)*wsize/xarraysize,string(id(i)),charsize=0.6,align=0.7,/device

return

end
