;procedure to display an image with its stars magnitudes at the detected positions x,y.

;SYNTAX: 
;plotid,image,x,y,mag[,windownumber][,RANGE=[minmag,maxmag]][,PLOTRANGE=plotrange][,PRINT='postsript_file.ps'][,/PC]

;OPIONAL INPUTS: 
;windownumber is the id number of the window you want to display
;RANGE=[minmag,maxmag] is the range of magnitudes you want to write on the screen
;PLOTRANGE=max means that the image is display like "tvscl,image<max instead" of tvscl,image
;PRINT='postscript_file.ps' : set this keyword if you want to print the image in a post script file'
;/PC : set this when you use the PRINT keyword and if you work on a PC

;NOTE: what is writen on the screen is mag*100.



PRO plotmag ,image,x,y,mag,windownumber,range=range,print=print,plotrange=plotrange,PC=pc


if N_params() LT 3 then begin
	print,'Syntax: plotid,image,x,y,mag[,windownumber][,RANGE=[minmag,maxmag]][,PLOTRANGE=plotrange][,PRINT=''postsript_file.ps''][,/PC]'
	return
endif

if keyword_set(range) then a=where((mag LT range(1)) AND (mag GT range(0))) else a=indgen(n_elements(mag))

if a(0) EQ -1 then a=indgen(n_elements(mag))

if NOT keyword_set(plotrange) then plotrange=max(image) 

if N_params() LT 5 then windownumber=9


sizex=n_elements(image(0,*))
sizey=n_elements(image(*,0))

window,windownumber,title='image with id',xsize=sizex,ysize=sizey
	tvscl,image<plotrange(0)
	starnumber=N_elements(a)
	print,'number of stars displayed:',starnumber 
	for i=0,starnumber-1 do begin
		xyouts,x(a(i)),y(a(i)),string(fix(mag(a(i))*100)),charsize=0.6,align=0.3,/device
		
	endfor
if keyword_set(PRINT) then begin
	set_plot,'ps'
	device,filename=print
	tvscl,image<plotrange(0)
for i=0,starnumber-1 do xyouts,x(a(i))/float(sizex)*612/870.,y(a(i))/float(sizey),string(fix(mag(a(i))*100.)),charsize=0.6,align=0.3

	device,/close 
	if keyword_set(PC) then set_plot,'WIN' else set_plot,'x'
endif
return

end
