   ; POLYFIT: fit a set of data with a polynomial of fixed degree.
   ;	The best fit coefficients are determined as the least squares
   ;	solution of a normal system of equations. Matrix inversion is
   ;	performed by means of GINV (Moore-Penrose generalized inverse).

   ; INPUT
   ;	x0: observation points
   ;	y0: observed values
   ;	[WEIGHTS = ]: vector of weights for the observed values y
   ;	degree: degree of polynomial
   ;	[/NO_CONST]: fit a polynomial without constant term
   ; OUTPUT
   ;	c: coefficients of the polynomial
   ;	yfit: polynomial evaluated at the observation points


   ; POW_ARRAY: compute observation array for LS fit.

   FUNCTION pow_array, x, degree, NO_CONST = no_const

	if  keyword_set( no_const )  then begin
	   p = 1  &  a = x # replicate( 1, degree )
	endif else begin
	   p = 0  &  a = x # replicate( 1, degree + 1 )
	endelse
	i = 0
	while  p le degree  do begin
	   a[*,i] = a[*,i]^p  &  i = i + 1  &  p = p + 1
	endwhile
	return, transpose( a )
   end


   PRO polyfit, x0, y0, WEIGHTS = w, degree, NO_CONST = no_const, c, yfit

	x = x0  &  y = y0
	x_array = pow_array( x, degree, NO_CONST = no_const )
	ls_sys, x_array, y, WEIGHTS = w, ls_x_array, ls_y
	c = transpose( min_norm_inversion( ls_x_array, ls_y ) )
	yfit = transpose( c # x_array )
	return
   end




;  ; RENORMAL: renormalization of observation points.
;
;  FUNCTION renormal, x
;
;	a = float( min( x ) )  &  b = float( max( x ) )
;	ar = -1.  &  br = +1.
;	xr = ar - ( br - ar ) / ( b - a ) * a + ( br - ar ) / ( b - a ) * x
;	return, xr
;   end

;	if  keyword_set( renorm )  then begin
;	   x = renormal( x )  &  y = renormal( y )
;	endif


