   ; PSF_GAUSSIAN_BLUR: compute a space variant (SV) PSF as the convolution
   ; of a reference template (guide star, on-axis source) and a blurring
   ; kernel, represented by an elliptical gaussian, with its major axis
   ; oriented towards the reference position.

   ; INPUT
   ;	psf: reference PSF
   ;	x0, y0: position of reference source
   ;	x, y: local position where the SVPSF must be computed
   ;	NOTE: the physical dimensions of (x0,y0) and (x,y) (e.g. pixel units,
   ;	angular distance, etc.) must be defined according to the definition
   ;	used in the function GAUSSIAN_KERNEL
   ;	l1, l2, w1, w2: coefficients of l(r) and w(r) polynomials (see
   ;		ELLIPT_GAU_LW)
   ;	[_EXTRA = ]: optional input parameters of CONVOLUTION, GAUSSIAN_KERNEL,
   ;		CENTROIDER and IMAGE_SHIFT (if used)
   ;	[/SV_CENTER]: fractional shift of SVPSF to put its centroid in the
   ;		same sub-pixel position as the input PSF
   ; OUTPUT
   ;	Return the local SVPSF
   ;	kernel: blurring kernel

   FUNCTION psf_gaussian_blur, psf, x0, y0, x, y, l1, l2, w1, w2, $
   							   _EXTRA = extra, SV_CENTER = sv_center, kernel

	r = distance( x, y, x0, y0 )  &  tt = angle( x0, y0, x, y )
	ellipt_gau_lw, r, l1, l2, w1, w2, l, w
	kernel = gaussian_kernel( tt, l, w, _EXTRA = extra )
	svpsf = convolution( psf, kernel, /NO_NORM, _EXTRA = extra )
	if  keyword_set( sv_center )  then begin
	   dummy = centroider( psf, _EXTRA = extra, XSHIFT = xs1, YSHIFT = ys1 )
	   dummy = centroider( svpsf, _EXTRA = extra, XSHIFT = xs2, YSHIFT = ys2 )
	   svpsf = image_shift( svpsf, xs2 - xs1, ys2 - ys1, _EXTRA = extra )
	endif
	return, svpsf
   end
