   ; PSF_HERE: add a scaled psf to an image, at the location (x,y).
   ;	By default (x,y) will be the location of the PSF central pixel
   ;	after insertion. It is possible to take the maximum intensity
   ;	pixel as a reference for insertion (see INSERT).

   ; INPUT
   ;	psf, image (not having necessarily the same size)
   ;	x, y: location of psf center after insertion into image
   ;	scale: scale factor of psf
   ;	[_EXTRA = ]: see INSERT
   ; OUTPUT
   ;	Return image + inserted scaled psf

   FUNCTION psf_here, psf, image, x, y, scale, _EXTRA = extra

	insert, psf, image, _EXTRA = extra, x, y, lo_xp, up_xp, lo_yp, up_yp, $
	   		lo_xi, up_xi, lo_yi, up_yi, out_of_range
	if  not out_of_range  then $
	   image[lo_xi,lo_yi] = image[lo_xi:up_xi,lo_yi:up_yi] + $
	   					    scale * psf[lo_xp:up_xp,lo_yp:up_yp]
	return, image
   end
