   ; PTR_TO_CUBE: given a vector of pointers to a stack of frames,
   ; return a cube (3D array) containing the stack.
   ; CALLING SEQUENCE:
   ; cube = ptr_to_cube( stack ), if all the input images have the same size
   ; cube = ptr_to_cube( same_size( stack ) ), otherwise
   ; Set /FREE to destroy the input heap variable.

   FUNCTION ptr_to_cube, stack, FREE_PTR = free

	s2d = mysize( *stack[0], /DIM )  &  nframes = n_elements( stack )
	type = mysize( *stack[0], /TYPE )
	cube = make_array( s2d[0], s2d[1], nframes, TYPE = type )
	for  n = 0, nframes - 1  do  cube[*,*,n] = *stack[n]
	if  keyword_set( free )  then  ptr_free, stack
	return, cube
   end