   ; RECIPROCAL_DISTANCE: given a set of n points in a (x,y) plane,
   ;	compute their reciprocal distances.

   ; INPUT
   ;	x, y: vectors of x- and y- coordinates
   ; OUTPUT
   ;	Return a (n-1)*(n-1) floating point array of distances, defined as
   ;		d[j,*] = distances between the j-th point and the others,
   ;				 for j = 0, ..., n - 2
   ;	Return 0 if a single point is supplied
   ;	Return -1 if x and y have different size

   FUNCTION reciprocal_distance, x, y

	n = n_elements( x )
	if  n_elements( y ) ne n  then  return, -1
	if  n eq 1  then  return, 0
	d = fltarr( n - 1, n - 1 )  &  s = lindgen( n )
	for  i = 0, n - 2  do begin
	   other = ( shift( s, -i ) )[1:n-1]  &  other = shift( other, +i )
	   d[*,i] = distance( x[other], y[other], x[i], y[i] )
	endfor
	return, transpose( d )
   end
