   ; REMOVE_COINCIDENT: given a set of points on a plane (x,y),
   ;	remove coincident points.

   ; INPUT
   ;	x, y: x- and y- coordinates of points
   ; OUTPUT
   ;	x_distinct, y_distinct: set of distinct points



   ; ADD_POINTS: auxiliary procedure called by REMOVE_COINCIDENT.

   PRO add_points, x, y, x_out, y_out, n

	if  n eq 0  then begin
	   x_out = x[n]  &  y_out = y[n]	; one point is distinct!
	endif else begin
	   add_points, x, y, x_out, y_out, n - 1
	   if  min( distance( x_out, y_out, x[n], y[n] ) ) ne 0  then begin
	      x_out = add_elements( x_out, x[n] )
	      y_out = add_elements( y_out, y[n] )
	   endif
	endelse
	return
   end


   PRO remove_coincident, x, y, x_distinct, y_distinct

	npt = n_elements( x )
	if  npt eq 0 or n_elements( y ) ne npt  then  return
	add_points, x, y, x_out, y_out, npt - 1
	x_distinct = x_out  &  y_distinct = y_out
	return
   end
