   ; ROT_COORD: compute rotated coordinates in a reference
   ; frame having the origin at the peak of a given image.

   ; INPUT
   ;	image: input image defining reference frame
   ;	angle: rotation angle [rad.], measured counter-clockwise starting
   ;		from the x axis (columns)
   ; OUTPUT
   ;	rx, ry: rotated coordinates, having the origin at the image peak

   PRO rot_coord, image, angle, rx, ry

	m = get_max( image )  &  s = mysize( image, /DIM )
	x = findgen( s[0] ) - m[0]  &  y = findgen( s[1] ) - m[1]
	x = x # replicate( 1, s[1] )  &  y = replicate( 1, s[0] ) #  y
	rx =  x * cos( angle ) + y * sin( angle )
	ry = -x * sin( angle ) + y * cos( angle )
	return
   end

