; Gauss-Newton algoritm - Without scaling
; p = fi, tx, ty

PRO rotate1, x, y, xp, yp, p, res

n=1
epsilon=1e-12

nele=n_elements(x)            ; To be used in the jacobian
prel=DIndGen(nele)+1
ones=-1*transpose(prel/prel)
zeroes=0*ones
x=transpose(x) & y=transpose(y) & xp=transpose(xp) & yp=transpose(yp)
n=1; 
WHILE (n GT epsilon) DO BEGIN
	f=[[x-xp*cos(p(0))+yp*sin(p(0))-p(1)],$
	   [y-xp*sin(p(0))-yp*cos(p(0))-p(2)]]
	J=[[xp*sin(p(0))+yp*cos(p(0)), ones, zeroes], $
           [-xp*cos(p(0))+yp*sin(p(0)), zeroes, ones]]
        least_square,J,f,dp
        p=p-dp
        n=norm(dp)
ENDWHILE
print,''
print,'Angle (degree)= ',strtrim(p(0)*180./3.1415,1)
print,'X translation = ',strtrim(p(1),1)  
print,'Y translation = ',strtrim(p(2),1)
print,''
for i=0,n_elements(x)-1 do begin 
		xp(i)=xp(i)*cos(p(0))-yp(i)*sin(p(0))+p(1)
		yp(i)=xp(i)*sin(p(0))+yp(i)*cos(p(0))+p(2)
	endfor
	xerr=x-xp & yerr=y-yp
	print,transpose(xerr),transpose(yerr)
	print,'Mean residual error after rotation and translation:'
	print,'		X error = ',strtrim(mean(xerr),1)
	print,'		Y error = ',strtrim(mean(yerr),1) & print,''
res=p
END

