   ; SAME_SIZE: given a stack of images, pad each image with 0's so
   ; that all the frames have the same final size and the peak at the
   ; same location. Useful to combine PSF stars having different sizes.

   ; INPUT
   ;	stack: vector of pointers to the 2D images
   ; OUTPUT
   ;	Return stack of images are described above
   ; NOTE: the original stack is overwritten.

   FUNCTION same_size, stack

	nframes = n_elements( stack )
	lx = lonarr( nframes )  &  ux = lx  &  ly = lx  &  uy = lx
	for  n = 0, nframes - 1  do begin
	   s = mysize( *stack[n], /DIM )  &  m = get_max( *stack[n] )
	   lx[n] = m[0] + 1  &  ux[n] = s[0] - 1 - m[0]
	   ly[n] = m[1] + 1  &  uy[n] = s[1] - 1 - m[1]
	endfor
	lxm = max( lx )  &  sx = lxm + max( ux )
	lym = max( ly )  &  sy = lym + max( uy )
	for  n = 0, nframes - 1  do $
	   *stack[n] = extend_array( *stack[n], sx, sy, $
	   							 X_OFF = lxm - lx[n], Y_OFF = lym - ly[n] )
	return, stack
   end
