   ; SAMPLING_GRID: define a grid of sampling points along a
   ;	reference axis.

   ; INPUT
   ;	n: number of points
   ;	dx: sampling step
   ; OUTPUT
   ;	Return n-elements floating point vector
   ;	lx, ux: bounds of sampling domain (useful for spline interpolation)
   ; NOTE
   ;	Each point is in the middle of a pixel.

   FUNCTION sampling_grid, n, dx, lx, ux

	x = findgen( n ) * dx + dx / 2.
	lx = min( x ) - dx / 2.  &  ux = max( x ) + dx / 2.
	return, x
   end


