   ; SPACE_VARIANT: compute a space variant (SV) PSF as the convolution of a
   ;	reference template (guide star, on-axis source) and a blurring kernel.

   ; INPUT
   ;	psf: reference PSF
   ;	x0, y0: position of reference source
   ;	x, y: local position where the SVPSF must be computed
   ;	[FUN_KERNEL = ]: string, containing the name of a function to compute
   ;		a normalized (total volume = 1) blurring kernel. It must be
   ;		defined as follows:
   ;		result = kernel_fun( x, y, x0, y0, _EXTRA = extra )
   ;		(default = GAUSSIAN_KERNEL)
   ;	NOTE: the physical dimensions of (x0,y0) and (x,y) (e.g. pixel units,
   ;	angular distance, etc.) must be defined according to the definition
   ;	used in the function 'KERNEL_FUN'
   ;	[_EXTRA = ]: optional input parameters of CONVOLUTION, KERNEL_FUN,
   ;		CENTROIDER and IMAGE_SHIFT (if used)
   ;	[/SV_CENTER]: fractional shift of SVPSF to put its centroid in the
   ;		same sub-pixel position as the input PSF
   ; OUTPUT
   ;	Return the local SVPSF
   ;	[KERNEL = ]: blurring kernel

   FUNCTION space_variant, psf, x0, y0, x, y, FUN_KERNEL = kernel_fun, $
   					_EXTRA = extra, SV_CENTER = sv_center, KERNEL = kernel

	if  n_elements( kernel_fun ) eq 0  then  kernel_fun = 'gaussian_kernel'
	kernel = call_function( kernel_fun, x, y, x0, y0, _EXTRA = extra )
	svpsf = convolution( psf, kernel, /NO_NORM, _EXTRA = extra )
	if  keyword_set( sv_center )  then begin
	   dummy = centroider( psf, _EXTRA = extra, XSHIFT = xs1, YSHIFT = ys1 )
	   dummy = centroider( svpsf, _EXTRA = extra, XSHIFT = xs2, YSHIFT = ys2 )
	   svpsf = image_shift( svpsf, xs2 - xs1, ys2 - ys1, _EXTRA = extra )
	endif
	return, svpsf
   end
