   ; SPLINE_INTERP: given the coefficients of a 2-D spline defined over the
   ;	set of knots (x_knots,y_knots) and expressed as a linear combination
   ;	of B-splines, compute the spline on a grid (x,y).

   ; INPUT
   ;	c: 2-D array of coefficients, returned by SPLINE_COEFF
   ;	x_knots, y_knots: x- and y- knots, returned by SPLINE_COEFF
   ;	x, y: abscissae and ordinates defining the 2-D grid (x,y) over
   ;		which the spline has to be evaluated. The following checks are
   ;		performed:
   ;		min( x_knots ) <= x <= max( x_knots)
   ;		min( y_knots ) <= y <= max( y_knots)
   ;		If some x or y does not fulfills these conditions, it is replaced
   ;		by the corresponding bound on x_knots and y_knots
   ;	[DEGREE = ]: odd degree of spline (default = 3)
   ; OUTPUT
   ;	Return 2-D array of spline-interpolated values. The array size is the
   ;	same as the input array of coefficients.

   FUNCTION spline_interp, c, x_knots, y_knots, x, y, DEGREE = degree

	if  n_elements( degree ) eq 0  then  degree = 3
	x_points = ( x > min( x_knots ) ) < max( x_knots )
	y_points = ( y > min( y_knots ) ) < max( y_knots )
	b_splines, x_points, x_knots, degree, bx, kx, /BOUNDS, /FULL
	b_splines, y_points, y_knots, degree, by, ky, /BOUNDS, /FULL
											; delta_t = 2.7
	return, transpose( bx ) # c # by		; delta_t = 336
   end
