   ; SPLINE_MAGNIFY: magnify an image by an integer factor, by means of
   ;	spline interpolation.

   ; INPUT
   ;	image: image to be magnified
   ;	[DEGREE = ]: degree of spline (default = 3)
   ;	xmag: integer x- magnification factor (>= 1)
   ;	[ymag]: integer y- magnification factor (>= 1)
   ;		(default = xmag)
   ; OUTPUT
   ;	Return magnified image.
   ;	error: boolean, true if an error occurs in the computation of
   ;		the spline (e.g. when the input image size is too small).
   ;		In this case, the input image is returned
   ; NOTE: the input image is supposed to be sampled on the grid
   ;	x(k) = k * (dx/2), k = 0, ..., N - 1, dx = 1
   ;	The output image is defined on the grid
   ;	x(k) = k * (dx/2), k = 0, ..., N*mag - 1, dx = 1/mag

   FUNCTION spline_magnify, image, DEGREE = d, xmag, ymag, error

	error = 0B
	if  n_params() eq 2  then  ymag = xmag
	xm = round( xmag )  &  ym = round( ymag )
	if  xm eq 1 and ym eq 1  then  return, image
	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	spline_coeff, image, DEGREE = d, c, kx, ky
	error = n_elements( c ) eq 1
	if  error  then  mag_image = image  else $
	begin
	   x = sampling_grid( sx * xm, 1. / xm )
	   y = sampling_grid( sy * ym, 1. / ym )
	   mag_image = spline_interp( c, kx, ky, DEGREE = d, x, y )
	endelse
	return, mag_image
   end