PRO stats_noise9,filename,sigma_width,max,span,patch_width,PRINT=print,FRAME=frame,PC=pc
;
;   stats_noise9,'a:\k367map.fits'  ,0.3,1500,4,5 /PC
;   stats_noise9,'a:\k367map.fits'  ,0.3,1500,4
;   stats_noise9,'a:\k367map.fits'  ,0.3,1500
;   stats_noise9,'a:\k367map.fits'  ,0.3  (too low)
;   stats_noise9,'a:\k367map.fits'
;   stats_noise9,'a:\k367map.fits'  ,0.3, PRINT='test.ps'
;
;   stats_noise9,'a:\Final_T1.fits' ,93,800,1000,5
;   stats_noise9,'a:\Final_T1.fits' ,93,800,1000
;   stats_noise9,'a:\Final_T1.fits' ,93,800
;   stats_noise9,'a:\Final_T1.fits' ,93  (too low)
;   stats_noise9,'a:\Final_T1.fits'
;   stats_noise9,'a:\Final_T1.fits' ,93, PRINT='test.ps'
;
;	gaussian fit does not work - worse than stats_noise8
;		bad fit at start
;		final in has wrong peak by 50%
;	parameter  values are strange
;	TEST ON A SQUARE SINGLE FRAME
;
;       sigma_width 	is the half or sigma width of the
;                                       noise distribution
;
;       max             is the maximum number of occurances to be
;                                       plotted it is also the cutoff for
;                                       the fitting gaussian
;
;       span            is the range of values which is plotted,
;                                       and also defines the cutoff for the
;                                       fitting of the gaussian.
;
;       patch_width is the width of the patch to be used in
;                                       the median average
;
;       binsize         is the size of the bin (not in use yet)
;
;               array is the size of an edge of the square array
;
;       OPERATING PROCEDURE
;               Set the parameters to approximately the proper
;               values.  Then lower the value of "max" to the
;       top of the gaussian noise distribution, then adjust
;               the width to contain the peak, but not much of the
;               tails.
;stats_noise9,'filename'[,sigma_width[,max[,span[,patch_width]]]],PRINT='psfilename',FRAME=framenumber,[/PC]
; (or FRAME='average')
;
N=N_PARAMS()

if (N LT 1) OR (N GT 6) THEN begin
print,''
print,'SYNTAX : stats_noise9,''filepath/file.fits'',sigma_width,[max,[span,[patch_width]]],[PRINT=''histogram.ps''],[FRAME=framenumber (or FRAME=''average'')]
print,''
print,'You can also replace ''filepath/file.fits'' with an argument which contains the data cube. For example stats_noise9,image,sigma_width....'
print,''
print,'patch_width is the width of the patch to be used in the median average
print,''
print,'sigma_width is half the width of the noise distribution '
print,''
print,'span  is the range of values which is plotted and also defines the cutoff for the fitting of the gaussian.
print,''
print,'max is the maximum number of occurances to be plotted it is also the cutoff for the fitting gaussian'
print,''
print,'PRINT=''histogram.ps'' to create a postscript file which contains the plot, if you run idl on pc set also ",/PC" to write the file'
print,''
print,'in case of data cube, statistics are done on the first frame, or if keyword "FRAME" is set then you can specify the id number of frame to be used. Tape FRAME=''average'' to work on the average of the cube'

return
endif
filename0=filename
datasize=size(filename0)
datatype=datasize(n_elements(datasize)-2)
if datatype EQ 7 then fits_read, filename0, a else begin
		a=filename0
		filename0='data'
		endelse

a_dim=size(a)
if a_dim(0) EQ 3 then begin
        if NOT keyword_set(FRAME) then frame=0
        if string(frame) EQ 'average' then a=total(a,3)/a_dim(3) else a=a(*,*,frame)
endif

xarray=N_ELEMENTS(a(0,*))
yarray=N_ELEMENTS(a(*,0))

m = fltarr(xarray,yarray)

if N LT 5 THEN patch_width=5

m = median(a,patch_width)
d = a - m     ; d is the array of median corrected single pixel noise

dvector1 = d[*,20]
dvector2 = d[*,30]
dvector3 = d[*,40]
dvector4 = d[*,50]
dvector5 = d[*,60]

result1 = MOMENT(dvector1)
result2 = MOMENT(dvector2)
result3 = MOMENT(dvector3)
result4 = MOMENT(dvector4)
result5 = MOMENT(dvector5)

dv1   = sqrt(result1[1])
dv2   = sqrt(result2[1])
dv3   = sqrt(result3[1])
dv4   = sqrt(result4[1])
dv5   = sqrt(result5[1])
mean1 =      result1[0]

dvector_array = [dv1,dv2,dv3,dv4,dv5]
dvector  = MIN(dvector_array)

print, "dv1 = ", dv1
print, "dv2 = ", dv2
print, "dv3 = ", dv3
print, "dv4 = ", dv4
print, "dv5 = ", dv5
print, "dvector = ", dvector
print,  "mean = " , mean1

; result = MOMENT(dvector1)
; print, 'mean               = ' , result[0]
; print, 'variance           = ' , result[1]
; print, 'standard deviation = ',  sqrt(result[1])

if N LT 2 THEN sigma_width = dvector
print, ' patch_width = ', patch_width

if N LT 4 THEN span=mean1+4*dvector
print, ' span = ' , span

if N LT 4 THEN span= 14 * sigma_width * 0.5
print, ' span = ' , span

binsize=10/100.*4*patch_width
print,'bin size:',binsize

binsize=0.0347*sigma_width

type=a_dim(n_elements(a_dim)-2)
if (type EQ 2) OR (type EQ 3) then binsize=1.

print,'bin size:',binsize

if N LT 3 THEN max=xarray*yarray*0.007*1.8

x=findgen(span/binsize)*binsize-span/2.

Hd=HISTOGRAM(d, BINSIZE = binsize, MIN = -span/2., MAX =span/2.0001 )

Nx  = N_ELEMENTS(x)
NHd = N_ELEMENTS(Hd)

if (Nx LT NHd) then Hd=Hd(0:Nx-1)

window,0,title='file: '+filename0
PLOT,x,Hd, yrange=[0.,max*1.],xrange=[-span/2.,span/2.], PSYM = 3,title='stats noise histogram ('+filename0+')',ytitle='counts',xtitle='range of values'

print,''
Hd = Hd < max
yfit = GAUSSFIT(x,Hd,Ag , NTERMS=5)

print,'FIT: a0*EXP[-0.5*((x-a1)/a2)^2]+ a3 + a4*x '
PRINT,'peak value      = ',ag(0)
print,'center position = ',ag(1)
print,'sigma width     = ',ag(2)
print,'background value= ',ag(3)
print,'background slope= ',ag(4)
OPLOT, x, yfit
xyouts,88,472,'sigma width  = '+string(ag(2)),/device
xyouts,88,461,'peak value = '+string(ag(0)),/device

; window,1
; tvscl,m>(-300)<10

; window,2
 ;tvscl,d>0<1

if keyword_set(PRINT) then begin
        set_plot,'ps'
        device,filename=print

        PLOT,x,Hd, yrange=[0.,max*1.],xrange=[-span/2.,span/2.], PSYM = 3,title='stats noise histogram ('+filename0+')',ytitle='counts',xtitle='range of values'
        OPLOT, x, yfit
xyouts,-span/2.*0.95,max*0.99,'sigma width  = '+string(ag(2))
xyouts,-span/2.*0.95,max*0.94,'peak value = '+string(ag(0))
        device,/close
        if keyword_set(PC) then set_plot,'WIN' else set_plot,'x'
endif

print,'done'
return
END