PRO stats_value4,filename,span,max,FRAME=frame
;
;   stats_value2,'k367map.fits', 100, 1000, 450
;			binsize = 0.05
;   stats_value2,'Final_T1.fits', 5000, 100, 256
;			binsize = 0.5

;        can use decimal values for span
;        span should be smoothly divisible by 4
;
;
;   located in /home/dcurrie/analysis/sharp_A/stats_value.pro
;
;	1)	move x axis to zero
;	2) 	try log x
;	3)	automate frame size selection
;	4)	[automate binsize]
;
;	span = 5
;	max = 100
;	array = 256
;
N=N_PARAMS()

a = readfits(filename)

a_dim=size(a)
if a_dim(0) EQ 3 then begin
	if NOT keyword_set(FRAME) then frame=0
	if string(frame) EQ 'average' then a=total(a,3)/a_dim(3) else a=a(*,*,frame)	
endif

xarray=N_ELEMENTS(a(0,*))
yarray=N_ELEMENTS(a(*,0))

binsize=0.1
x=FINDGEN(span/binsize)*binsize  -(span/2.)

Hb=HISTOGRAM(a, BINSIZE = binsize, MIN = -(span/2.), MAX = +(span/2.001))
Nx  = N_ELEMENTS(x)
NHb = N_ELEMENTS(Hb)
if (Nx LT NHb) then Hb=Hb(0:Nx-1)

!P.MULTI=[0,1,2]

window,4
PLOT,x,Hb, PSYM = 3,xrange=[min(x),max(x)],yrange=[0.,max*1.0],xtitle='pixels values',ytitle='counts',title='Histogram of '+filename
noth=max(Hb,id)
if x(id) LT 0 THEN x=x-x(id)+0.01
;x=abs(x)
;print,noth,x(id(0))
PLOT,x(id:*),Hb(id:*), yrange=[1.,max*1.0],xrange=[x(id),max(x)],xtitle='pixels values',ytitle='counts',psym=3,title='Histogram of '+filename+' in log scale of pixels values', /XLOG


!P.MULTI=0

return
END




