   ; SUB_IMAGES: extract a stack of sub-images from a given image.
   ; Each sub-image is centered at a specified position (x,y), which
   ; is normally the location of a peak (e.g. a star). The size of
   ; each sub-image may be quoted either as a multiple of the peak
   ; FWHM or pre-fixed by the user.

   ; INPUT
   ;	image
   ;	x, y: x- and y- coordinates of the peaks
   ;	[boxes]: scalar or vector, representing the size of each sub-image
   ;	[N_FWHM = ]: specify box size for n-th peak in terms of its FWHM
   ;	[_EXTRA = ]: optional parameters of FWHM
   ; OUTPUT
   ;	Return vector of pointers to the extracted sub-images
   ; NOTE: each peak must the absolute maximum in its box.
   ; If this condition is not fulfilled, the peak is rejected

   FUNCTION sub_images, image, x, y, boxes, N_FWHM = n_fwhm, _EXTRA = extra

	nframes = n_elements( x )
	if  n_elements( y ) ne nframes  then  return, -1
	stack = ptrarr( nframes, /ALLOCATE_HEAP )
	; Extract sub-images
	for  n = 0, nframes - 1  do begin
	   if  n_elements( n_fwhm ) ne 0  then $
	      box = round( n_fwhm * $
	   				   fwhm( image, X = x[n], Y = y[n], _EXTRA = extra ) ) $
	   else  box = boxes[ n < ( n_elements(boxes)-1 ) ]
	   *stack[n] = extract( image, X = x[n], Y = y[n], box, $
	   						LO_X = lx, LO_Y = ly )
	   m = get_max( *stack[n] )
	   if  m[0] ne ( x[n] - lx ) or m[1] ne ( y[n] - ly )  then $
	      stack[n] = ptr_new()
	endfor
	; Reject 'secondary' sources
	w = where( ptr_valid( stack ), count )
	if  count eq 0  then  stack = -1  else  stack = stack[w]
	return, stack
   end
