   ; SUBS_TO_COORD: given a vector of subscripts identifying a set of pixels
   ;	in a 2-D array, transform the subscripts to 2-D coordinates.

   ; INPUT
   ;	subs: 1-D vector of subscripts
   ;	n_columns: number of columns in the 2-D array

   ; OUTPUT
   ;	x, y: column and row coordinates of the pixels subscripted by subs,
   ;		such that  array[subs] = array[x,y]

   PRO subs_to_coord, subs, n_columns, x, y

	s = round( subs)  &  x = s mod n_columns  &  y = s / n_columns
	return
   end