   ; SUPERPOSE_STARS: given the coordinates of a set of stars in an
   ; image, extract boxes centered on the candidate stars and superpose
   ; them by median combination, after sub-pixel centering (optional)
   ; and normalization.
   ; It is possible to perform a weighted median superposition: the weigths
   ; are proportional to the square root of the original peak intensities,
   ; representing estimates of the signal to noise ratio in the photon noise
   ; case.

   ; INPUT
   ;	image: image containing stars
   ;	x, y: coordinates of candidate stars
   ;	box: size of box centered on each star
   ;	[/SUB_PIX]: sub-pixel accuracy centering of each stellar image
   ;	[/WEI_MED]: weighted median superposition
   ;	[_EXTRA = ]: optional parameters of CENTROIDER, STACK_MEDIAN
   ; OUTPUT
   ;	Return combination of selected stars

   FUNCTION superpose_stars, image, x, y, box, _EXTRA = extra, $
   							 SUB_PIX = sub_pix, WEI_MED = weighted

	; Extract sub-images
	stack = sub_images( image, x, y, box )
	nframes = n_elements( stack )
	; Sub-pixel centering
	if  keyword_set( sub_pix )  then  for  n = 0, nframes - 1  do $
	   *stack[n] = centroider( *stack[n], _EXTRA = extra )
	; Define weights for median superposition
	if  keyword_set( weighted )  then begin
	   w = fltarr( nframes )
	   for  n = 0, nframes - 1  do  w[n] = sqrt( max( *stack[n] ) > 0 )
	endif
	; Normalize sub-images
	for  n = 0, nframes - 1  do  *stack[n] = normalize( *stack[n] )
	; Pad sub-images with 0's to the same size
	stack = same_size( stack )
	; Compute stack median
	combined = stack_median( ptr_to_cube( stack, /FREE ), WEIGHTS = w )
	return, combined
   end
