   ; SV_CONVOLUTION: convolve an image with a space-variant point spread
   ;	function, modeled pixel by pixel as the convolution of a space-
   ;	invariant reference template and a local blurring kernel, computed
   ;	by a user-supplied function.

   ; INPUT
   ;	image, sipsf: image and space-invariant template
   ;	x0, y0: position of SIPSF. The physical unitss of (x0,y0) must be
   ;		defined according to the definition used in KERNEL_FUN (below)
   ;	[KERNEL_FUN = ]: string, containing the name of the function to
   ;		compute the blurring kernel (default ''). It must
   ;		be defined as follows:
   ;		result = kernel_fun( x0, y0, x, y, KER_SIZE = ker_size ),
   ;		where ker_size is a 2-element array containing the kernel size
   ;		All auxiliary data required by this function must be passed by
   ;		means of common block
   ;	[/STORE]: set this keyword to store in memory the 2D blurring kernels
   ;		for each pixel in the image
   ;	[_EXTRA = ]: set of optional keyword parameters of CONVOLUTION
   ;	[KERNELS = ]: 2D array of pointers to the blurring kernels, computed
   ;		in a previous call to SV_CONVOLUTION
   ; OUTPUT
   ;	Return the space-variant convolution
   ;	ker_array: 2D array of pointers to the blurring kernels
   ;		for each pixel in the image (active only if /STORE is set)


   FUNCTION sv_convolution, image, sipsf, x0, y0, KERNEL_FUN = kernel_fun, $
   							_EXTRA = extra, STORE = store, ker_array

	on_error, 1
	if  n_elements( kernel_fun ) eq 0  then  kernel_fun = ''
	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	blurred = image - image
	compute_ker = n_elements( ker_array ) eq 0
	store = keyword_set( store ) and compute_ker
	if  keyword_set( store )  then $
	   ker_array = ptrarr( sx, sy, /ALLOCATE_HEAP )
	for  i = 0, sy - 1  do  for  j = 0, sx - 1  do begin
	   if  compute_ker  then begin
	      kernel = call_function( kernel_fun, x0, y0, j, i, _EXTRA = extra, $
	      						  KER_SIZE = ker_size )
	      if  keyword_set( store )  then  *ker_array[j,i] = kernel
	   endif else begin
	      kernel = *ker_array[j,i]
	      ker_size = mysize( kernel, /DIM )
	   endelse
	   blurred = psf_here( kernel, blurred, j, i, image[j,i], $
	   				SSX = ker_size[0], SSY = ker_size[1], LSX = sx, LSY = sy )
	endfor
	return, convolution( blurred, sipsf, _EXTRA = extra )
   end
