PRO synth0,dim0,psf0,magrange,d,ron,res,plot=plot
starnumber=2
magmin=magrange(0)
magmax=magrange(1)
stararray=fltarr(dim0,dim0)
size=starnumber-1

x=fltarr(2)
y=fltarr(2)
mag=fltarr(2)
flux=fltarr(2)

x(0)=dim0/2-d/2
y(0)=dim0/2
x(1)=dim0/2+d/2
y(1)=dim0/2
mag=magrange

;give the flux to each point on the array
for i=0,size do begin
stararray(x(i),y(i))=10^((25-mag(i))/2.5)
endfor

;Enter psf file. 
rdpsf,psfname,hpsfname,psf0
psfname=psfname/total(psfname)

;convolution with CONVOLVE (use image and psf fft's) quite faster than CONVOL
simage = convolve(stararray, psfname, FT_PSF = psf_FT )

;add the Read Out Noiseprint,''
simage=simage+randomn(seed,dim0,dim0)*ron

;add photon noise
simage=abs(simage+randomn(seed,dim0,dim0)*Sqrt(abs(simage)))

if keyword_set(plot) then begin 
		window,10,title='Synthetic array of stars',xsize=dim0,ysize=dim0
		tvscl,simage
		window,12
		shade_surf,simage
endif

res=simage
end






