
;stars features 
read,starnumber,prompt='how many stars ?: '
print,''
read,magmin,prompt='magnitude of the brightest star: '
print,''
read,dev,prompt='standart deviation (pixels) for the gaussian distribution: '
print,'' 

y=''
size=starnumber-1
starvalues=fltarr(4,starnumber)
stararray=fltarr(256,256)

starvalues(0,*)=indgen(starnumber)+1 			;id

;generate a table of random positions x y and mag (plus id to indentificate the
;stars. The positions have a gaussian distribution with a mean of 127 and a standart deviation of dev
s=127+randomn(seed,2,starnumber)*dev			; x , y 

;if some stars are out of the image then they are replace with an unif.distri.
	a=where(s GT 256 OR s LT 0,count)	 
	if count NE 0 then begin
		for i=0,count-1 do begin
		s(a(i))=randomu(seed,1)*256
		endfor
	endif 

starvalues(1,*)=fix(s(0,*))
starvalues(2,*)=fix(s(1,*))

;mag limit value is magmin and uniformly distributed between magmin and 25
starvalues(3,*)=magmin+(25-magmin)*randomu(seed,1,starnumber)	

;give the flux to each point on the array
for i=0,size do begin
stararray(starvalues(1,i),starvalues(2,i))=10^((25-starvalues(3,i))/2.5)
endfor

;Enter psf file. (512*512)  Default is Eisenhaur's PSF from NGC3603
read,y,prompt=' Enter psf file. Return for Eisenhaur''s PSF from NGC3603: '
if y NE '' then psfref=readfits(y,hpsfref)
if y EQ '' then psfref=readfits('~/ngc3603/kpsf.fits',hpsfref)

;resize and normalize the image of psf 
psfref=psfref(129:384,129:384)
psfref=psfref/total(psfref)

;convolution with CONVOLVE (use image and psf fft's) quite faster than CONVOL
simage = convolve(stararray, psfref, FT_PSF = psf_FT )

;add the Read Out Noise
print,''
read,ron,prompt='Supply the Read Out Noise in electrons:  '
print,''
simage0=simage+randomn(seed,256,256)*ron

;add photon noise
simage=abs(simage+randomn(seed,256,256)*Sqrt(simage))

;add dark current
;read,tin,prompt='integration time: '
;simage=simage+5.79*Exp(-1/(26.9*tin))

window,10,title='Synthetic array of stars',xsize=256,ysize=256
tvscl,simage

;write data in fits files
read,y,prompt='write data in fits files? y/n: '
if y EQ 'y' then begin
	read,y,prompt='name for convolved image  .fits: '
	writefits,y,simage
	read,y,prompt='name for stars values (id,x,y,mag)  .fits: '
	writefits,y,starvalues
	read,y,prompt='name for star (points) array  .fits: '
	writefits,y,stararray
endif
retall 

end






