PRO Zern_num, num, M = m, N = n, INFO = info
;+    
;Procedure
;  Zern_num, num, M=m, N=n, INFO=info
;
;Description
;  ZERN_NUM calcule le degre azimutal M et le degre radial N du
;  NUM-ieme polynome de Zernike.
;
;Arguments
;  N       degre radial
;  M       degre azimutal
;  NUM     numero du polynome de Zernike
;  INFO    affichage du resultat
;
;Historique
;
;   Fri Aug 5 08:57:19 1994, Eric THIEBAUT <eric@zoe>		
;-
    on_error, 2
    IF n_elements(num) NE 1L THEN BEGIN
        message, "SYNTAX: ZERN_NUM, NUM, M=m, N=n"
    END
    IF ((j = long(num))) NE num OR j LT 1L THEN BEGIN
        message, "ERROR: NUM must be an integer greater or equal 1"
    END
    n = long(sqrt(8L*j-7L)-1L)/2L
    IF n MOD 2 THEN BEGIN                  ;Cas ou n impair
        m = 1L+2L*((j-1L-(n*(n+1L))/2L)/2L)
    END ELSE BEGIN                         ;Cas ou n pair
        m = 2L*((j-(n*(n+1L))/2L)/2L)
    END
    IF keyword_set(info) THEN print, j, n, m
END







