;The pro Zernike greates the zernike polinomials and Vector creates the
;radial, azimutal and pariry vector for the modes

;######################################################################

Pro Vector,Modes=Modes,N,M,P

;
;
;
;
;
;

If Not(Keyword_Set(Modes)) Then Modes=15

A=1
B=0
C=0
D=0
N=IntArr(Modes)
M=IntArr(Modes)
P=IntArr(Modes)

Repeat Begin
   B=B+1
   E=0
   F=0
   G=0
   X=B/2.0
   X=X-Fix(X)
   While ((E LE B) AND (A LT Modes)) Do Begin
      N(A)=B
      CC=0
      IF (G EQ 1) Then Begin
         M(A)=M(A-1)
         G=0
      EndIF Else Begin
         IF (F GT 1) Then Begin
            M(A)=M(A-1)+2
            G=G+1
         EndIF Else Begin
            IF (X GT 0.4) Then Begin
               M(A)=1
               F=F+1
            EndIF Else Begin
               X1=C/2.0
               X1=X1-Fix(X1)
               IF (X1 GT 0.4) Then Begin
                  C=0
               EndIF Else Begin
                  C=C+1
               EndElse
               M(A)=0
               P(A)=0
               CC=1
               F=F+2
            EndElse
         EndElse
      EndElse
      IF (CC EQ 0) Then Begin
         IF (C EQ 0) Then Begin
            IF (D EQ 0) Then Begin
               P(A)=0
               D=D+1
            EndIF Else Begin
               P(A)=1
               D=0
            EndElse
         EndIF Else Begin
            IF (D EQ 0) Then Begin
               P(A)=1
               D=D+1
            EndIF Else Begin
               P(A)=0
               D=0
            EndElse
         EndElse
      EndIF
      A=A+1
      E=E+1
   EndWhile
EndRep Until (A EQ Modes)

Return
End

;###########################################################

Pro Zernike_e_mod,Modes=Modes,diam_pup,ima_size,Z

; This routines creates the first "Modes" zernike polinomials
; The output is a cube Dim X Dim of "modes" zernike polinomials.
;

IF Not(Keyword_Set(Modes)) Then Modes=15

;Dim=128
Dim = ima_size
;Pup_Rad=32
Pup_Rad=diam_pup/2.

X=Rebin(Findgen(Dim),Dim,Dim)-Dim/2.
Y=Rotate(X,1)
Rho=double(Sqrt(X^2.+Y^2.)/Pup_Rad)
Ang=Atan(Y,X)
;Pup=Shift(Dist(Dim),Dim/2.,Dim/2.)/Pup_rad
;Pup=Float(Pup LT 1.0)
Pup = makepupil(ima_size,diam_pup,0,xc=diam_pup/2D0-0.5,yc=diam_pup/2D0-0.5)
Vector,Modes=Modes,N,M,P

Z=Fltarr(Dim,Dim)
;Z=Fltarr(Dim,Dim,Modes)

;For I=1,Modes-1 Do Begin  
I = Modes-1
   R=0

   For J=0,(N(I)-M(I))/2 Do Begin
      S=J
      R=R+(-1.)^J*Fact(N(I)-J)/(Fact(S)*Fact((N(I)+M(I))/2-J)$_
        *Fact((N(I)-M(I))/2-J))*Rho^(N(I)-2*J)
   Endfor

   IF (M(I) EQ 0) Then ZZ=Sqrt(N(I)+1)*R
   IF (M(I) NE 0) Then Begin
      IF (P(I) EQ 0) Then ZZ=Sqrt(N(I)+1)*Sqrt(2.0)*Cos(M(I)*Ang)*R
      IF (P(I) GT 0) Then ZZ=Sqrt(N(I)+1)*Sqrt(2.0)*Sin(M(I)*Ang)*R
   EndIF

   Z(*,*)=ZZ*Pup

;EndFor

Return
End
