PRO SH_pentes, im, slopes,tiltterm,focusterm,rmsslope,meanslope,angleterm,MASKPARA=MASKPARA,$
				REMOVETILT=REMOVETILT,REMOVEFOCUS=REMOVEFOCUS,FOCUSFACTOR=FOCUSFACTOR,SHCONFIG=SHCONFIG, $
				FOCUSOFFSET=FOCUSOFFSET,ROTA=ROTA,DATATYPE=DATATYPE,SUBFLUX=SUBFLUX,REMOVEREF=removeref,$
				REFSLOPE=refslope,LARGFOC=LARGFOC,MASKARRAY=MASKARRAY

;PURPOSE:	Compute slopes from a SH image and some parameters like general tiptilt, focus, grid rotation
;			Ouput a slope vector containing or not focus,tiptilt,grid rotation term
;
;INPUTS:	im:array to be processed

;OUPUTS:	slopes: computed slopes
;			tiltterm: general tip tilt term	average of xslope and yslope (2 elements vector)
;			focusterm: scalar, ROC computed by projecting the slopes along the direction to the image centre and taking the average of it
;			rmsslopes: scalar, standart deviation of slopes
;			meanslope: scalar, MEAN(SQRT(Xslope^2+Yslope^2))
;			angleterm: scalar, grid rotation computed by projecting the slopes along the perpendicular direction to the image centre and taking the average of it

;KEYWORDS:
;			REMOVEREF=1 when reference slope REFSLOPE must be subtracted
;			REMOVESLOPE= optional contains the array of reference slope to be removed
;			REMOVETILT=1 when tip tilt term should be removed from output slopes vector ELSE REMOVETILT=0
;			REMOVEFOCUS=1 when focus term should be removed from output slopes vector ELSE REMOVEFOCUS=0
;			FOCUSFACTOR=1 by default, set this value to a linear correction of the focus term computation (because the program take into account focals length and f# which are not 100% exact)
;			FOCUSOFFSET=0 by default, set this parameter to correct for a constant offset in the focus term measurement (because the grid is slightly magnified with respect to the pixel grid)
;			ROTA=1 when the grid rotation component should be removed from output slopes vector ELSE ROTA=0
;			MASK= take into account only subaperture which are vignetted less
;
;			SHCONFIG= 5 element vector
;				SHCONFIG(0)=nsub=number of sub-aperture in a raw
;				SHCONFIG(1)=npix=number of pixel per-subaperture in a raw
;				SHCONFIG(2)=firstlensfocal= focal of pupil re-imaging lens in front of lenslet array (mm)
;				SHCONFIG(3)=lensletfocal= focal of lenslet array (mm)
;				SHCONFIG(4)=pixelsize= size of 1 pixel in mm
;			For MAD config is SHCONFIG=[8,8,30.7,3.2,0.024]


;--------------identification des parametres contenus dans SHCONFIG
nsub=SHCONFIG(0) & npix=SHCONFIG(1) & firstlensfocal=SHCONFIG(2) & lensletfocal=SHCONFIG(3) & pixelsize=SHCONFIG(4) & pupdiam=SHCONFIG(6)

dsubap=fltarr(nsub,nsub)& pente=fltarr(nsub,nsub,2) & pentesanstilt=fltarr(nsub,nsub,2)
distxy=fltarr(nsub,nsub) & angle=fltarr(nsub,nsub) & subflux=fltarr(nsub,nsub)
focusarray=fltarr(nsub,nsub) & xabs=fltarr(nsub) & yabs=fltarr(nsub) & teta=fltarr(nsub,nsub)

;----DEFINE THE MASK if not supplied and count how many subapertures(=1) to take into account
mask=maskarray
if total(mask) EQ 0 THEN mask=SHpupil(npix*nsub,npix,npix*pupdiam,maskpara(1),maskpara(0)/100.0,CENTER=[maskpara(2),maskpara(3)]) ;to take into account more vigneted subaperture increase VIG
a=where(mask EQ 1,Nsubap)
nsubap=float(nsubap)

;-------------SLOPES MEASUREMENT FOR EACH SUBAPERTURE----------------------
IF DATATYPE EQ 'frames' THEN BEGIN

  IF largfoc EQ 0 THEN BEGIN
	for i=0,nsub-1 do begin
		for j=0,nsub-1 do begin
		if mask(i,j) EQ 1 THEN BEGIN
			sub0=im(i*npix:(i+1)*npix-1,j*npix:(j+1)*npix-1)
			wheremax,sub0,x,y,/noprint
			x=x(0)-(npix/2.) & y=y(0)-(npix/2.)
			if i EQ 0 THEN x=x>0 & if j EQ 0 THEN y=y>0
			if i EQ (nsub-1) THEN x=x<0 & if j EQ (nsub-1) THEN y=y<0
			sub1=im(i*npix+x:(i+1)*npix-1+x,j*npix+y:(j+1)*npix-1+y)
			sub1=sub1-min(sub1)
			pente(i,j,*)=(subapcentroid(sub1)-[npix/2.0-0.5-x,npix/2.0-0.5-y]) ;*mask(i,j)

			;mesure de la pente dans la sous pupille sub
			;pente(i,j,*)=(subapcentroid(sub)-[npix/2.0-0.5,npix/2.0-0.5])*mask(i,j)
			;mesure de la valeur absolue de la pente
    		distxy(i,j)=Sqrt(pente(i,j,0)^2+pente(i,j,1)^2)
    		;mesure du flux dans chaque sous ouverture
    		subflux(i,j)=total(sub0) ;*mask(i,j)
    	ENDIF
		endfor
	endfor
  ENDIF ELSE BEGIN
  	image=im
  	checktiltfocus,image,mask,npix,nsub,pupdiam,maskpara,lensletfocal,xm,ym,kexp

  	for i=0,nsub-1 do begin
		for j=0,nsub-1 do begin
		sub0=im(i*npix:(i+1)*npix-1,j*npix:(j+1)*npix-1)
		if mask(i,j) EQ 1 THEN BEGIN
			xi=npix*(i+0.5) & yj=npix*(j+0.5) ; centre theorique sans focus
			xc=round(xm-kexp*(xm-xi)) & yc=round(ym-kexp*(ym-yj));computer new coordinates of subaperture taking into account grid expension
			sub0=im((xc-npix/2)>0:(xc+npix/2-1)<(npix*nsub-1),(yc-npix/2)>0:(yc+npix/2-1)<(npix*nsub-1))
			sub=sub0-min(sub0)
		  	wheremax,sub,x,y,/noprint
			x=x(0)-(npix/2.) & y=y(0)-(npix/2.)
			if i EQ 0 THEN x=x>0 & if j EQ 0 THEN y=y>0
			if i EQ (nsub-1) THEN x=x<0 & if j EQ (nsub-1) THEN y=y<0
			sub1=im((xc-npix/2+x)>0:(xc+npix/2-1+x)<(npix*nsub-1),(yc-npix/2+y)>0:(yc+npix/2-1+y)<(npix*nsub-1))
			sub1=sub1-min(sub1)
		  pente(i,j,*)=(subapcentroid(sub1)-[npix/2.0-0.5+(xi-xc)-x,npix/2.0-0.5+(yj-yc)-y])*mask(i,j)
		  ;mesure de la valeur absolue de la pente
    	  distxy(i,j)=Sqrt(pente(i,j,0)^2+pente(i,j,1)^2)
    	ENDIF
    	;mesure du flux dans chaque sous ouverture
    	subflux(i,j)=total(sub0)*mask(i,j)
		endfor
	endfor

  ENDELSE

ENDIF ELSE BEGIN ;take slopes if input are slopes and not frames
	pente(*,*,0)=slopes(*,*,0)*mask
	pente(*,*,1)=slopes(*,*,1)*mask
ENDELSE

;-------------REMOVE REFERENCE-----------------------------
IF REMOVEREF EQ 1 THEN BEGIN
	pente(*,*,0)=(pente(*,*,0)-refslope(*,*,0))*mask
	pente(*,*,1)=(pente(*,*,1)-refslope(*,*,1))*mask
ENDIF

;------------FOCUS and ROTATION estimation from slope computation-----------
tiltterm=[total(pente(*,*,0))/Nsubap,total(pente(*,*,1))/Nsubap]

if not keyword_set(focusfactor) then focusfactor=1; if no calibration focus factor is 1
if not keyword_set(focusoffset) then focusoffset=0; if no calibration focus offset is 0.0 (consider grid magnification as 0)

For i=0,nsub-1 do begin
	for j=0,nsub-1 do begin
	xabs(i)=npix*(i+0.5-maskpara(2)) & yabs(j)=npix*(j+0.5-maskpara(3)) ;OLD: xabs(i)=npix*(i+0.5-nsub/2.0) & yabs(j)=npix*(j+0.5-nsub/2.0)
	dsubap(i,j)=Sqrt((xabs(i))^2+(yabs(j))^2);distance in pix from grid center to subaperture centre
	pentesanstilt(i,j,0)=(pente(i,j,0)-tiltterm(0))*mask(i,j);soustraction des residus de tip tilt
	pentesanstilt(i,j,1)=(pente(i,j,1)-tiltterm(1))*mask(i,j)
	teta(i,j)=Atan(yabs(j),xabs(i)) ;angle [pupil X axis,pupilcenter-subaperture centre] counterclockwise
	focusarray(i,j)= pentesanstilt(i,j,0)*cos(teta(i,j)) + pentesanstilt(i,j,1)*sin(teta(i,j));projection on axis going from subaperture centre to pupil centre
   	angle(i,j)= -pentesanstilt(i,j,0)*sin(teta(i,j)) + pentesanstilt(i,j,1)*cos(teta(i,j))
	angle(i,j)=Atan(angle(i,j),dsubap(i,j))*180/3.14156*mask(i,j)
	;focusarray(i,j)=focusarray(i,j)*firstlensfocal^2/(lensletfocal*(dsubap(i,j)+0.01))*mask(i,j) ; old formula to compute directly focus shift before the pupil lens
	focusarray(i,j)=(focusarray(i,j))/(dsubap(i,j)*lensletfocal)*mask(i,j) ;this is in fact egal to 1/ROC for each subap, the inverse is done later to avoid division by zeros
	endfor
endfor

focusterm=total(focusarray)/(Nsubap*focusfactor); - focusoffset; average on each subaperture and correction from calibration measurement
focusterm=1/focusterm ; FOCUSTERM is NOW egal to the ROC !!!!!!!!!!!!!!!!!!!!
angleterm=total(angle)/Nsubap
;------------------------fin calcul de focus-------------------------------

distsanstilt=Sqrt(pentesanstilt(*,*,0)^2+pentesanstilt(*,*,1)^2)
	;k=firstlensfocal^2/(lensletfocal)
	k=lensletfocal/focusterm
	kk=180/3.1415
slopes=pente

;in case removetilt set, then remove the tilt from results
if REMOVETILT EQ 1 then begin
	meanslope=total(distsanstilt)/Nsubap
	slopes=pentesanstilt
	tiltterm=[total(slopes(*,*,0))/Nsubap,total(slopes(*,*,1))/Nsubap]
endif else begin
	meanslope=total(distxy)/Nsubap
endelse

;in case removefocus set, then remove the focus and tilt from results
if (REMOVEFOCUS EQ 1) AND (ROTA EQ 0) then begin
	;slopes(*,*,0)=(pentesanstilt(*,*,0)-focusterm/k*dsubap*cos(teta))*mask
	;slopes(*,*,1)=(pentesanstilt(*,*,1)-focusterm/k*dsubap*sin(teta))*mask
	slopes(*,*,0)=(pentesanstilt(*,*,0)-dsubap*k*cos(teta))*mask ;new formula when focusterm is egal to ROC
	slopes(*,*,1)=(pentesanstilt(*,*,1)-dsubap*k*sin(teta))*mask
	distsanstilt=Sqrt(slopes(*,*,0)^2+slopes(*,*,1)^2)
	tiltterm=[total(slopes(*,*,0))/Nsubap,total(slopes(*,*,1))/Nsubap]
	meanslope=total(distsanstilt)/Nsubap
	focusterm=0.0
endif

;in case rotation removal set, then remove rotation and tilt component from slopes
if (ROTA EQ 1) AND (REMOVEFOCUS EQ 0) THEN BEGIN
	slopes(*,*,0)=(pentesanstilt(*,*,0)+tan(angleterm/kk)*dsubap*sin(teta))*mask
	slopes(*,*,1)=(pentesanstilt(*,*,1)-tan(angleterm/kk)*dsubap*cos(teta))*mask
	distsanstilt=Sqrt(slopes(*,*,0)^2+slopes(*,*,1)^2)
	tiltterm=[total(slopes(*,*,0))/Nsubap,total(slopes(*,*,1))/Nsubap]
	meanslope=total(distsanstilt)/Nsubap
	angleterm=0.0
endif

;in case rotation and focus removal set, then remove tip, tilt, focus, and rotation from slopes
if (ROTA EQ 1) AND (REMOVEFOCUS EQ 1) THEN BEGIN
		slopes(*,*,0)=(pentesanstilt(*,*,0)-dsubap*(k*cos(teta)-tan(angleterm/kk)*sin(teta)))*mask
		slopes(*,*,1)=(pentesanstilt(*,*,1)-dsubap*(k*sin(teta)+tan(angleterm/kk)*cos(teta)))*mask
		distsanstilt=Sqrt(slopes(*,*,0)^2+slopes(*,*,1)^2)
		tiltterm=[total(slopes(*,*,0))/Nsubap,total(slopes(*,*,1))/Nsubap]
		meanslope=total(distsanstilt)/Nsubap
		angleterm=0.0
		focusterm=0.0
endif

rmsslope=stddev(distsanstilt)*sqrt(nsub^2/Nsubap)

end