PRO checktiltfocus,array,mask,npix,nsub,pupdiam,maskpara,fl,xm,ym,kexp


;t0=systime(1)
;the procedure assume that find.pro finds almost all spots

;a=where(mask EQ 1,c)
m=median(array) & s=stdev(array)
xabs=fltarr(nsub) & yabs=fltarr(nsub)
dsubap=fltarr(nsub,nsub)

;d=dsubap+dsubap/roc*fl
;t1=systime(1)
;for a normal subaperture grid compute the distance from the subap to the nominal centre, put zeros in array when mask=0
for i=0,nsub-1 do begin
for j=0,nsub-1 do begin
		array(i*npix:(i+1)*npix-1,j*npix:(j+1)*npix-1)=array(i*npix:(i+1)*npix-1,j*npix:(j+1)*npix-1)*mask(i,j)    ; array contain zero where mask=0
		xabs(i)=npix*(i+0.5-maskpara(2)) & yabs(j)=npix*(j+0.5-maskpara(3)) ;OLD: xabs(i)=npix*(i+0.5-nsub/2.0) & yabs(j)=npix*(j+0.5-nsub/2.0)
		dsubap(i,j)=Sqrt((xabs(i))^2+(yabs(j))^2)*mask(i,j);distance in pix from grid center to subaperture centre
endfor
endfor
;t2=systime(1)
find,array,x,y,f,s,r,m+s/2.,1.,[-1.,1.0],[-1.,1.],/silent ;try to find spot in the array using m+s/2. threshold
;t3=systime(1)
xm=mean(x) & ym=mean(y) ;compute centre of optical axis by averaging all spot coordinates
n=n_elements(x) & dis=fltarr(n)
a=where(dsubap NE 0,cts)
dsub=dsubap(a) ;take only subap distance where mask is 1
z=sort(dsub)
dsub=dsub(z) ; sort dsub in increasing order

;for each found spots compute its distance from the center xm,ym, reject doublon
for i=0,n-1 do begin
	if i NE 0 then b=where(((x(0:i-1)-x(i))^2+(y(0:i-1)-y(i))^2) LT npix/2) else b=-1 ;this is to reject doublons
	if b(0) EQ (-1) THEN dis(i)=sqrt((x(i)-xm)^2+(y(i)-ym)^2) ELSE  dis(i)=-1       ;this is distance computation
endfor

k=where(dis NE -1,c)
d=dis(k)

if c LT N_elements(dsub) THEN dsub=dsub(0:c-1) ;reject the furthest subapertures to have exactly the same number taken into account
kexp=mean(d)/mean(dsub)

;t4=systime(1)
;print,t1-t0,t2-t1,t3-t2,t4-t3,t4-t0

print,fl/((mean(d)/mean(dsub))-1),kexp-1
print,xm/npix,ym/npix

;loadct,1
;win,0,960
;help,dsub,k
;tvscl,alog10(array+0.01)
;plots,x(k),y(k),psym=1,/device
;plots,xm,ym,psym=5,/device

end


