PRO FIELDCURV, path,xidentifier,yidentifier,coefx,coefy,background,taglist,tagnumber,datatype,CONFIG=CONFIG,TAGNAME=TAGNAME,MASKPARA=MASKPARA,$
				REMOVEBACK=REMOVEBACK,FOCUSFACTOR=FOCUSFACTOR,focusoffset=focusoffset,CURVONLY=CURVONLY,CENTREXY=CENTREXY,SHCONFIG=SHCONFIG

;	PURPOSE:	The input data should be SH images taken over the field of view if possible symetric around the orgin
;				The program compute focus term for each fibre position and make a contour plot of the result
;
;	INPUTS: 	path: string array, list of filepath to be read, pathname should contain X and Y coordinates
;				xidentifier: carrater(s) preceding the X coordinate in the pathname like X_
;				yidentifier: carrater(s) preceding the Y coordinate in the pathname	like Y_
;				background: background image to be subtracted

;	OUTPUT:		coefx: tilt angle corresponding to the misalignment of the X stage with the nominal focal plane
;				coefy: tip angle corresponding to the misalignment of the Y stage with the nominal focal plane

;	KEYWORDS:	MASKEDGE: same as PENTES64 program
;				REMOVEBACK=1 if background subtraction should be performed ELSE REMOVEBACK=0
;				FOCUSFACTOR:same as PENTES64 program
;				FOCUSOFFSET:same as PENTES64 program
;				CURVONLY=1 when focus term due to XY stage tiptilt misalignment should be removed ELSE CURVONLY=0
;				CENTREXY=[xc,yc],default is [0,0], set when plot axis origin should be offset to a new value like the XYstage on axis position for instance


nfile=n_elements(path)
xyaxis=fltarr(nfile,2)
fterm=fltarr(nfile)
rmsterm=fltarr(nfile)
meanterm=fltarr(nfile)

for k=0,nfile-1 do begin
	read_rtc_fits,path(k),frames,taglist,tagnumber,datatype,CONFIG=CONFIG,TAGNAME=TAGNAME
	if removeback EQ 1 then frames=frames-background

	SH_pentes, frames, slopes,tiltterm,focusterm,rmsslope,meanslope,angle,MASKPARA=MASKPARA,$
				REMOVETILT=0,REMOVEFOCUS=0,FOCUSFACTOR=FOCUSFACTOR,SHCONFIG=SHCONFIG, $
				FOCUSOFFSET=FOCUSOFFSET,ROTA=0,DATATYPE=DATATYPE
	;pentes64,frames,slopes,tiltterm,focusterm,rmsslope,meanslope,angle,
	;			REMOVETILT=0,REMOVEFOCUS=0,ROTA=0,focusfactor=focusfactor,focusoffset=focusoffset ; compute focus term for each file
	fterm(k)=focusterm
	rmsterm(k)=rmsslope
	meanterm(k)=meanslope

	;looking for X Y axis value in the filename
 	positionoffirst_x=STRPOS(path(k),xidentifier,/reverse_search) ;detect where is the last "identifier" in the string
	if positionoffirst_x EQ -1 then print,'carracter identifer is not matching, be careful to lower case'
 	xvalue=strmid(path(k),positionoffirst_x+STRLEN(xidentifier),6); extract 6 digit after the last "identifier", the "-" is allowed

	positionoffirst_y=STRPOS(path(k),yidentifier,/reverse_search) ;detect where is the last "identifier" in the string
	if positionoffirst_y EQ -1 then print,'carracter identifer is not matching, be careful to lower case'
 	yvalue=strmid(path(k),positionoffirst_y+STRLEN(yidentifier),6); extract 6 digit after the last "identifier", the "-" is allowed

	;concatenation of axis values read in the filename (when axis specified), divide by 1000 to get mm
 	if (positionoffirst_x NE -1) AND (positionoffirst_y NE 1) then xyaxis(k,*)=[long(xvalue(0)),long(yvalue(0))]/1000.0

endfor

;correct for a general slope in the measurement for instance if the stages on which
; the fibre is mounted is not exactly paralell to the nominal focal plane
coefx=[0,0] & coefy=[0,0]
if CURVONLY EQ 1 THEN BEGIN
	coefx=LADFIT(xyaxis(*,0),fterm);,yfit=fitx)
	coefy=LADFIT(xyaxis(*,1),fterm);,yfit=fity)
endif
fterm=fterm-xyaxis(*,0)*coefx(1)-xyaxis(*,1)*coefy(1)

;Make the field centre at 0,0, this is just an offset in the display
xoffset=0 & yoffset=0
IF keyword_set(CENTREXY) THEN BEGIN
	xoffset=centrexy(0)
	yoffset=centrexy(1)
endif
xyaxis(*,0)=xyaxis(*,0)-xoffset & xyaxis(*,1)=xyaxis(*,1)-yoffset


;triangulate,xyaxis(*,0),xyaxis(*,1),tri
;Result = TRIGRID( xyaxis(*,0),xyaxis(*,1),fterm,tri,/quintic )

;DISPLAY CONTOUR IN THE CURRENT WINDOW
loadct,1	;blue color display
contour,fterm,xyaxis(*,0),xyaxis(*,1),/irregular,/isotropic,/fill,nlevels=50,$
		xtitle='X axis (mm)',ytitle='Y axis (mm)',title='Mapping of Focus estimate'
contour,fterm,xyaxis(*,0),xyaxis(*,1),/irregular,nlevels=11,/isotropic,$
		C_labels=[1,1,1,1,1,1,1,1,1,1,1],/overplot


;window,5
;plot,xyaxis(*,0),fterm,psym=1
;oplot,xyaxis(*,0),fitx
;window,6
;plot,xyaxis(*,1),fterm,psym=2
;oplot,xyaxis(*,1),fity

end