FUNCTION PHASE2AI_, PHASE = phase, MODES = modes, INVERSE_ZIZJ = inverse_zizj, $
                   NBMODES =  nbmodes, LARGEUR = largeur,  PUPDIAM = pupdiam, $
                   ZIZJ_OUTPUT = zizj_output,DOUBLE = double, SILENT = silent,PMASK=PMASK,MASKARRAY=MASKARRAY

; ROUTINE PHASE2AI MODIFIED, FOLLOWING DESCRIPTION IS NOT VALID ANYMORE (KEPT FOR REFERENCE ONLY)

;   PHASE2AI - Dcomposition d'une carte de phase sur une base de modes
;
;SYNTAXE :
;   ai = PHASE2AI( PHASE = phase
;                  [[, MODES = modes, INVERSE_ZIZJ = inverse_zizj] |
;                   [, NBMODES = nbmodes, LARGEUR = largeur, PUPDIAM = pupdiam
;                    , OCCULTATION = occultation]] [, ZIZJ_OUTPUT= zizj_output]
;                  [, /DOUBLE] [, /SILENT] [, /VERSION] [, /HELP])
;
;DESCRIPTION :
;   PHASE2AI calcule la dcomposition d'une carte de phase sur une base de
;   modes, par exemple des polynmes de Zernike avec occultation centrale.
;
;   Le calcul est une inversion matricielle ; soit \phi=\sum_{i=1}^{N} a_i.Z_i,
;   alors on a les N quations suivantes :
;   <\phi; Z_j> = \sum_{i=1}^{N} a_i <Z_i; Z_j>
;   donc le vecteur A des a_i est A = <Z_i; Z_j>^{-1} B, o b_j = <\phi; Z_j>.
;
;   Les modes peuvent
;   - soit tre passs en argument
;   - soit, pour des Zernike, tre calculs par le programme  partir de
;     NBMODES, PUPDIAM (voire de LARGEUR et OCCULTATION).
;
;   UTILISATION TYPIQUE :
;   - 1er appel avec NBMODES, PUPDIAM (voire LARGEUR et OCCULTATION) comme
;     entres,  MODES et INVERSE_ZIZJ  comme sorties.
;   - Appels suivants avec MODES et INVERSE_ZIZJ en entre.
;
;   ARGUMENTS :
;
;   PHASE        : (entre) phase dont on veut la dcomposition.
;
;   MODES        : (entre ou sortie) modes, i.e., base, sur laquelle on veut
;                  la dcomposition. Si ce mot-cl contient une variable non
;                  nulle, alors MODES est utilis comme entre. Sinon, ce
;                  mot-cl reoit les MODES calculs en sortie, pour une
;                  utilisation ultrieure.
;
;   INVERSE_ZIZJ : (entre ou sortie) inverse de la matrice des produits
;                  scalaires entre modes, ncessaire au calcul des ai. Si ce
;                  mot-cl contient une variable non nulle, alors INVERSE_ZIZJ
;                  est utilis comme entre. Sinon, ce mot-cl reoit la
;                  matrice INVERSE_ZIZJ calcule en sortie, pour une
;                  utilisation ultrieure.
;
;   NBMODES      : (entre) NomBre de MODES  calculer, dans le cas o l'on
;                  veut utiliser des Zernike de 1  NBMODES.
;
;   PUPDIAM      : (entre) DIAMETRE en nombre de pixels (ventuellement non
;                  entier) de la pupille du tlescope, dans le cas o l'on
;                  veut utiliser des Zernike comme modes.
;
;   LARGEUR      : (entre) LARGEUR en nombre de pixels du tableau contenant
;                  la pupille du tlescope, dans le cas o l'on veut utiliser
;                  des Zernike comme modes. Si absent, est calcul
;                  automatiquement par POLAIRE2.
;
;   ZIZJ_OUTPUT  : (sortie) matrice des produits scalaires entre modes. Cette
;                  matrice n'est calcule que si elle est ncessaire, i.e. si
;                  la matrice INVERSE_ZIZJ n'a pas t fournie en entre.
;
;   /DOUBLE      : (entre) tous les calculs seront effectus en double
;                  prcision.
;
;   /SILENT      : (entre) mode anti-verbeux, pour utilisation rpte.

npix=PMASK(0) & mask=PMASK(1) & obstruc=PMASK(2) & xpup=PMASK(3) & ypup=PMASK(4) & nsub=largeur

IF (n_params() NE 0) OR keyword_set(help) OR NOT keyword_set(phase) OR $
    NOT ((keyword_set(nbmodes) AND keyword_set(pupdiam)) OR $
         keyword_set(modes)) $
    THEN BEGIN
    message, 'Aide demande ou syntaxe incorrecte. Documentation :', /INFO
    ;doc_library, routine_courante()
    retall
ENDIF

IF NOT keyword_set(double) THEN double = 0

IF NOT keyword_set(modes) THEN BEGIN
    ;IF NOT keyword_set(silent) THEN $
     ;       printf, -2, 'Calcul modes de Zernike 1  ' + nbr2str(nbmodes)+'.'
    ;modes = transpose(CALC_MODE_ZERNIKE(NBMODES = nbmodes,LARGEUR = largeur,PUPDIAM = pupdiam,OCCULT = occultation,$
    ;									double=double,MASK = mask,/PISTON, SILENT = silent))

;pupil definition
	Zmask=SHpupil(npix*nsub,npix,npix*pupdiam,obstruc,mask/100.0)
	Zmaskshift=maskarray ;SHpupil(npix*nsub,npix,npix*pupdiam,obstruc,mask/100.0,CENTER=[xpup,ypup])

;create zernike modes
	Zernike_e_,Modes=nbModes,pupdiam,largeur,zmask,array
	;for i=0,nbmodes-1 do array(*,*,i)=array(*,*,i)*Zmask

;in case pupil is touching edges then zero zernike returned
if total(Zmask) NE total(Zmaskshift) THEN begin
	modes=array
	return,fltarr(nbmodes)
endif

;take into account shifted pupils by decentering the modes pupils
	IF (xpup NE largeur/2.) OR (ypup NE largeur/2.) THEN BEGIN
		shifted=fltarr(largeur,largeur,nbmodes)
		where2d,array(*,*,0) NE 0,x,y
		FOR i=0,N_elements(x)-1 do BEGIN
					xpos=x(i)+xpup-largeur/2. & ypos=y(i)+ypup-largeur/2.
					if  (xpos LE largeur-1) AND (xpos GE 0) AND (ypos LE largeur-1) AND (ypos GE 0) $
						THEN shifted(xpos,ypos,*)=array(x(i),y(i),*)
		ENDFOR
		array=shifted
	ENDIF

modes=reform(array,largeur*largeur,nbmodes)

ENDIF ELSE BEGIN
    nbmodes = n_elements(modes[0, *]) ; ecrase un eventuel 'nbmodes' en arg.
    largeur = sqrt(n_elements(modes[*, 0]))
ENDELSE

bi_array = ((double NE 0) ? dblarr(nbmodes) : fltarr(nbmodes))

IF n_elements(phase) NE long(largeur)^2 THEN BEGIN
    printf, -2, '% Erreur : PHASE n''a pas largeur^2 lments :', $
            n_elements(phase), 'NE', largeur^2
    message, 'Je ne peux pas calculer les ai !'
ENDIF

IF NOT keyword_set(inverse_zizj) THEN BEGIN
	IF NOT keyword_set(silent) THEN printf, -2, 'Calcul de la matrice <Z_i; Z_j>.'

    zizj_output = ((double NE 0) ? dblarr(nbmodes, nbmodes) : $
                                   fltarr(nbmodes, nbmodes))
    FOR lej=0, nbmodes-1 DO BEGIN
      FOR lei=0, nbmodes-1 DO BEGIN
          zizj_output[lei,lej]= $ ; (1.0/nbpts)* $
              total(modes[*, lei]*modes[*, lej])
      ENDFOR
  ENDFOR

  IF NOT keyword_set(silent) THEN printf, -2, 'Inversion de la matrice <Z_i; Z_j>.'
    inverse_zizj = invert(zizj_output)
ENDIF

FOR indice = 0, nbmodes-1 DO BEGIN
;    bi_array[indice] = total(phase * mask * modes[*, indice]) / nbpts
    bi_array[indice] = total(phase * modes[*, indice]) ; / nbpts
ENDFOR

ai_array = inverse_zizj # bi_array
modes=array
return, ai_array

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;nbmodes = 21 ; dont piston
;pupdiam = 86.05
;largeur = 87
;occultation = 0.4

;; NOTE : j'attends le mot-cl /FAST par Amandine pour CALC_MODE_ZERNIKE
;; en attendant on transpose juste le rsultat :
;Z_array = transpose(CALC_MODE_ZERNIKE(NBMODES =  nbmodes,  $
 ;                           LARGEUR = largeur,  PUPDIAM = pupdiam, $
  ;                          OCCULT = occultation, /PIST),/double)

;; ventuellement rpter pour plusieurs ordres entre i=1 et 20 :
;ai = fltarr(nbmodes)
;ai[3] = 1. & ai[10] = 1.
;phase = reform(Z_array # ai, largeur, largeur)
;aff, phase
;shade_surf, phase,ax=65
;shade_surf, reform(Z_array[*, 3], largeur, largeur)

;invzizj = 0
;; avec MODES pr-calcul :
;ai_calcules = phase2ai(PHASE = phase, MODES =  Z_array, /Double, $
;                       inverse_zizj = invzizj)
;info,invzizj

;; avec MODES et INVERSE_ZIZJ pr-calculs :
;ai_calcules2 = phase2ai(PHASE = phase, MODES =  Z_array, /Double, $
;                       INVERSE_ZIZJ = invzizj)
;info, ai_calcules2-ai_calcules

;; avec ni MODES ni INVERSE_ZIZJ pr-calculs :
;ai_calcules3 = phase2ai(PHASE = phase, NBMODES =  nbmodes, /DOUBLE,  $
 ;                  LARGEUR = largeur,  PUPDIAM = pupdiam, $
  ;                     OCCULTATION = occultation)
;info, ai_calcules3-ai_calcules

;; avec sortie de ZiZj :
;ai_calcules4 = phase2ai(PHASE = phase, NBMODES =  nbmodes, $
 ;                  LARGEUR = largeur,  PUPDIAM = pupdiam, $
  ;                      OCCULTATION = occultation, zizj_output = zizj_output)
;aff, zizj_output
;info, ai_calcules4-ai_calcules ; petite diff. car ici calcul float

;print, ai_calcules
;print, 'Erreur max sur les ai :', max(abs(ai_calcules - ai))

;END
