
PRO READ_RTC_FITS,filepath,array,taglist,tagnumber,datatype,TAGNAME=TAGNAME,CONFIG=CONFIG


;TAG defines the type of data choosen as output
;HDR is the keyword that output the header instead
;STR: specify this keyword if the data is NOT under structure form

datatype='frames' ; by default the output is set to frame

CASE CONFIG OF

'PICSIGHT':	BEGIN
			poslastdot=STRPOS(filepath,'.',/reverse_search)
			ext=STRMID(filepath,poslastdot+1)
			IF (ext EQ 'fits') OR (ext EQ 'fts') OR (ext EQ 'fit') THEN ext='fits'

			CASE ext OF
			'bmp':		image=read_bmp(filepath)
			'fits':		BEGIN
							fits_open,filepath,imstruc				;LOOK FOR FITS STRUCTURE DEFINITION
							if ((imstruc.nbytes GE 2666880) AND (imstruc.bitpix EQ 16)) OR ((imstruc.nbytes GE 1451520) AND (imstruc.bitpix EQ 8))  THEN image=mrdfits(filepath,0>(imstruc.nextend-1), /UNSIGNED,/silent) $
							ELSE image=fltarr(1280,1040) ;SELECT THE LAST EXTENSION IN THE FITS STRUCTURE (last file of the cube), if image is not completely written then return blank
						END
			ELSE: image=fltarr(512,512)
			ENDCASE

			image=image(696-447:696+447-2,520-447:520+447-2)
			image=congrid(image,960,960,/center,cubic=-0.5)
			array=rebin(image,240,240)
			status=0 & tagNAME='NO TAG'& taglist=strarr(10) & tagnumber=0
			END

'PICSIGHT-FULL':	BEGIN
			poslastdot=STRPOS(filepath,'.',/reverse_search)
			ext=STRMID(filepath,poslastdot+1)
			IF (ext EQ 'fits') OR (ext EQ 'fts') OR (ext EQ 'fit') THEN ext='fits'

			CASE ext OF
			'bmp':	image=read_bmp(filepath)
			'fits':	BEGIN
						fits_open,filepath,imstruc				;LOOK FOR FITS STRUCTURE DEFINITION
						;help,imstruc,/str
						if ((imstruc.nbytes GE 2666880) AND (imstruc.bitpix EQ 16)) OR ((imstruc.nbytes GE 1451520) AND (imstruc.bitpix EQ 8))  THEN image=mrdfits(filepath,0>(imstruc.nextend-1), /UNSIGNED,/silent) $
							ELSE image=fltarr(1280,1040) ;SELECT THE LAST EXTENSION IN THE FITS STRUCTURE (last file of the cube), if image is not completely written then return blank
						END
			ELSE: image=fltarr(1280,1040)
			ENDCASE

			image=image(696-447:696+447-2,520-447:520+447-2)
			array=congrid(image,960,960,/center,cubic=-0.5)
			;array=REVERSE(array, 2) ; flip vertical for comparaison with HASO
			status=0 & tagNAME='NO TAG'& taglist=strarr(10) & tagnumber=0
			END

'CUSTOM':	 BEGIN
			struc=mrdfits(filepath,1,/silent,status=status)
			if status EQ 0 then begin
				array=struc
				tagNAME='NO TAG'& taglist=strarr(10) & tagnumber=0
			endif
			END

'MAD':		BEGIN
			struc=mrdfits(filepath,1,hdr,/silent,status=status)
			;definition des masques specifiques a MAD
			mask=fltarr(8,8)
			mask(*,*)=1
			mask(0,0:1)=0 & mask(0,0:1)=0 & mask(0,6:7)=0
			mask(7,0:1)=0 & mask(7,0:1)=0 & mask(7,6:7)=0
			mask(1,0)=0 & mask(6,0)=0 & mask(1,7)=0 & mask(6,7)=0

			;extract the array according to the supplied tag name
			taglist=tag_names(struc)
			possible_tag=['CCD0','CCD1','CCD2','GRADIENTS0','GRADIENTS1','GRADIENTS2']; liste des tags autorisant la lecture de la structure
			i=where(taglist EQ TAGNAME) ;cherche si lun des tags correspond au tagname fourni
			j=where(possible_tag EQ TAGNAME) ; cherche si le tag fourni peut etre lu

			if (i NE -1) AND (j NE -1) then begin ;
				array=struc.(i)
				dim=size(array)
				array=median(array,dimension=dim(0))
				tagnumber=i
			endif else begin ;if no match found then search for first tag in the tag list matching the potential ones
				matched=-1
				for i=n_elements(taglist)-1,0,-1 do begin
					k=where(possible_tag EQ taglist(i))
     				if k NE -1 then matched=i
				endfor
				if matched NE -1 then begin
					tagname=taglist(matched)
					tagnumber=matched
					array=struc.(matched)
					dim=size(array)
					array=median(array,dimension=dim(0))
				endif else	array=fltarr(64,64)
			endelse

			; extraction des slopes quand le TAG GRADIENTS0 est fourni
			IF (TAGNAME EQ 'GRADIENTS0') OR (TAGNAME EQ 'GRADIENTS1') OR (TAGNAME EQ 'GRADIENTS2')  THEN BEGIN
				slopeX=fltarr(8,8) & slopeY=fltarr(8,8)
				k=8^2-1 & j=0
				for i=0,k,1 do begin
					if mask(i) NE 0 then begin
					slopeX(i)=array(j)
					slopeY(i)=array(j+1)
					j=j+2
					endif
				endfor
				array=fltarr(8,8,2)
				array(*,*,0)=slopeX & array(*,*,1)=slopeY
				datatype='slopes'
			ENDIF

			;extraction des frames 2D a partir du vecteur a une dimension
			IF (TAGNAME EQ 'CCD0') OR (TAGNAME EQ 'CCD1') OR (TAGNAME EQ 'CCD2') THEN BEGIN
				frame=fltarr(64,64)
				for i=0,64*64-1 do frame(i)=array(i)
				array=frame
			ENDIF
			END

'AOF':	BEGIN
			struc=mrdfits(filepath,0,/silent,status=status)
			if status EQ 0 then begin
				array=struc
				tagNAME='NO TAG'
				taglist=strarr(10)
				tagnumber=0
			endif
			END

'HOT':		BEGIN
			struc=mrdfits(filepath,0,/silent,status=status)
			if status EQ 0 then begin
				array=struc
				tagNAME='NO TAG'
				taglist=strarr(10)
				tagnumber=0
			endif
			END

ENDCASE

IF status NE 0 then array=fltarr(512,512)


close,/all
END