Function WF_ZONAL,slopes,SHCONFIG=SHCONFIG,PMASK=PMASK,GENMATA=GENMATA,ACC=ACC

; INPUTS:;
;   SLOPES     	= array of (NxNx2) float containing slopes in radian data with X in (*,*,0) and Y in (*,*,1)
;	SHCONFIG	SHCONFIG= 5 element vector
;				SHCONFIG(0)=nsub=number of sub-aperture in a raw
;				SHCONFIG(1)=npix=number of pixel per-subaperture in a raw
;				SHCONFIG(2)=firstlensfocal= focal of pupil re-imaging lens in front of lenslet array (mm)
;				SHCONFIG(3)=lensletfocal= focal of lenslet array (mm)
;				SHCONFIG(4)=pixelsize= size of 1 pixel in mm
;			For MAD config is SHCONFIG=[8,8,30.7,3.2,0.024]
;	PMASK		= optional input mask on which the wavefront is reconstructed made of 1 and 0 (0 for masked data)
;	GENMATA	= optional input of inversion matrice A (computed by GENMAT_A function)
;
; OUTPUT:
; 2D array of reconstructed wavefront
;
; REMARKS: Algorythm solves linear equation system Ax=B (where x is wavefront map, A inversion matrix, B matrix computed from slopes)
; Method used is GAUSS SEIDEL algorythm through IDL GS_ITER function
;slopes=genfocus(20,pitch) ; generate slopes from focus array-XXXX-FOR TESTING

;--------------identification des parametres contenus dans SHCONFIG
N=SHCONFIG(0) & npix=SHCONFIG(1) & firstlensfocal=SHCONFIG(2) & fl=SHCONFIG(3) & pixsize=SHCONFIG(4) & pupdiam=SHCONFIG(6)

pitch=pixsize*npix

;if NOT keyword_set(GENMATA) then A=GENMAT_A_(N) else A=GENMATA
if NOT keyword_set(PMASK) then begin
	MASK=fltarr(n,n)
	MASK(*)=1
endif else begin
mask=pmask ;SHpupil(npix*N,npix,npix*pupdiam,pmask(1),pmask(0)/100.0,CENTER=[pmask(2),pmask(3)])
endelse

;EVALUATION DE LA MATRICE A
A=fltarr(n^2,n^2) & mask_=fltarr(N+2,N+2)
i=indgen(N,N)+1
mask_(1:N,1:N)=mask

for k=1,N do begin
for j=1,N do begin
	x=i(j-1,k-1)
	if mask_(j,k) EQ 0 then begin
	A(x-1,*)=0. ;si la souspupille consideree est masquee on met des zeros sur toute la ligne sauf sur la diagonale
	A(x-1,x-1)=1.
	endif else begin
	b=fltarr(4)
	b(*)=-1
	if mask_(j+1,k) EQ 1 then A(x-1,i(j,k-1)-1)=-1. else b(0)=0.
	if mask_(j-1,k) EQ 1 then A(x-1,i(j-2,k-1)-1)=-1.  else b(1)=0.
	if mask_(j,k+1) EQ 1 then A(x-1,i(j-1,k)-1)=-1.  else b(2)=0.
	if mask_(j,k-1) EQ 1 then A(x-1,i(j-1,k-2)-1)=-1.  else b(3)=0.
	A(x-1,i(j-1,k-1)-1)=-(total(b))
	endelse
endfor
endfor

;EVALUATION DE LA MATRICE B
Bjk=fltarr(N,N) & B=fltarr(N*N)
sx=fltarr(N,N) & sy=fltarr(N,N)
sx=slopes(*,*,0)*(pixsize/fl)*mask*pitch*1e6 & sy=slopes(*,*,1)*(pixsize/fl)*mask*pitch*1e6   ; on interchange x et y ca marche mais je comprends mal pourquoi
for j=1,N do begin
for k=1,N do begin
	if (j EQ 1) AND (k EQ 1) then bjk(j-1,k-1)=-(Sy(j-1,k)+Sy(j-1,k-1)+Sx(j,k-1)+Sx(j-1,k-1))
	if (j EQ 1) AND (k EQ N) then bjk(j-1,k-1)=-(-Sy(j-1,k-1)-Sy(j-1,k-1-1)+Sx(j,k-1)+Sx(j-1,k-1))
	if (j EQ N) AND (k EQ 1) then bjk(j-1,k-1)=-(Sy(j-1,k)+Sy(j-1,k-1)-Sx(j-1,k-1)-Sx(j-1-1,k-1))
	if (j EQ N) AND (k EQ N) then bjk(j-1,k-1)=-(-Sy(j-1,k-1)-Sy(j-1,k-1-1)-Sx(j-1,k-1)-Sx(j-1-1,k-1))
	if (j EQ 1) AND (k NE N) AND (K NE 1) then bjk(j-1,k-1)=-(Sy(j-1,k)-Sy(j-1,k-1-1)+Sx(j,k-1)+Sx(j-1,k-1))
	if (j EQ N) AND (k NE N) AND (k NE 1) then bjk(j-1,k-1)=-(Sy(j-1,k)-Sy(j-1,k-1-1)-Sx(j-1,k-1)-Sx(j-1-1,k-1))
	if (j NE 1) AND (j NE N) AND (k EQ 1) then bjk(j-1,k-1)=-(Sy(j-1,k)+Sy(j-1,k-1)+Sx(j,k-1)-Sx(j-1-1,k-1))
	if (j NE 1) AND (j NE N) AND (k EQ N) then bjk(j-1,k-1)=-(-Sy(j-1,k-1)-Sy(j-1,k-1-1)+Sx(j,k-1)-Sx(j-1-1,k-1))
	if (j NE 1) AND (j NE N) AND (k NE 1) and (k NE N) then begin
		sxm=Sx(j-1-1,k-1) & sxp=Sx(j,k-1) & sym=Sy(j-1,k-1-1) & syp=Sy(j-1,k)
	 	if mask(j-1,k) EQ 0 then Syp=-Sy(j-1,k-1)
		if mask(j-1,k-1-1) EQ 0 then Sym=-Sy(j-1,k-1)
		if mask(j,k-1) EQ 0 then Sxp=-Sx(j-1,k-1)
		if mask(j-1-1,k-1) EQ 0 then Sxm=-Sx(j-1,k-1)
		bjk(j-1,k-1)=-(Syp-Sym+Sxp-Sxm)
		if mask(j-1,k-1) EQ 0 then Bjk(j-1,k-1)=0.
	endif
endfor
endfor

B(*)=Bjk(*)/2.0

;true=where(mask EQ 1,Nsubap)
;tiltterm=[total(sx(*,*)*N)/Nsubap,total(sy(*,*)*N)/Nsubap]/4.
;Zernike_e,Modes=4,n,n,zcoef
;guess=(zcoef(*,*,1)*tiltterm(0)+zcoef(*,*,2)*tiltterm(1))*mask
;guess1=reform(guess,n^2)
guess1=fltarr(n^2)

; iterative GAUSS SIEDEL fonction
phas=gs_iter(A,B,lambda=1.8,max_iter=n^3,tol=acc,x_0=guess1)

;errormap=transpose((A##phas-B)/B)*100
;stat=moment(errormap(where(finite(errormap))),mdev=meandev)
;print,stat(0),meandev,sqrt(stat(1))

psi=fltarr(n,n)
psi(*)=phas(*)

;win,0,256
;check=psi-guess
;tvscl,congrid(check,256,256)

psi=(psi-min(psi))*mask

;i=where(psi NE 0)
;print,stdev(check(i))
;print,stdev(psi(i)),max(psi)

return,psi
end