/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;
import org.kordamp.jipsy.processor.Persistence;

public abstract class AbstractPersistence
implements Persistence {
    protected final String name;
    protected final String path;
    protected final Logger logger;

    public AbstractPersistence(String name, Logger logger, String path) {
        this.name = name;
        this.logger = logger;
        this.path = path;
    }

    @Override
    public void writeLog() {
        try {
            String logContent = this.logger.getFileContent();
            if (logContent != null && !logContent.isEmpty()) {
                this.write("log" + System.currentTimeMillis() + ".log", logContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String name, String value) throws IOException {
        this.logger.note(LogLocation.BOTH, "Generating file '" + this.path + name + "'");
        Writer writer = this.createWriter(name);
        try {
            writer.write("# Generated by " + this.name + "\n");
            writer.write("# " + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(new Date()) + "\n");
            writer.write(value);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public Collection<String> tryFind() {
        File dir = this.determineOutputLocation();
        Collection<String> fileList = dir == null ? Collections.emptyList() : this.listDiscoveredFiles(dir.listFiles(this.getFileFilter()));
        return fileList;
    }

    @Override
    public Collection<String> listDiscoveredFiles(File[] list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : list) {
            String fileName = file.getName();
            this.logger.note(LogLocation.LOG_FILE, "Discovered " + fileName);
            result.add(fileName);
        }
        return result;
    }

    protected abstract Writer createWriter(String var1) throws IOException;

    protected abstract FileFilter getFileFilter();
}

