/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public abstract class AbstractResourceInitializer
implements Initializer {
    protected final Filer filer;
    protected final String path;
    protected final Logger logger;

    public AbstractResourceInitializer(Logger logger, String path, Filer filer) {
        this.logger = logger;
        this.path = path;
        this.filer = filer;
    }

    @Override
    public CharSequence initialData(String name) {
        try {
            CharSequence result;
            FileObject resource = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path + name);
            try {
                result = this.tryWithReader(resource);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                this.logger.note(LogLocation.MESSAGER, "Eclipse gave an IOException: " + e.getMessage());
                return null;
            }
            catch (Exception other) {
                try {
                    result = resource.getCharContent(true);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                catch (IOException e) {
                    this.logger.note(LogLocation.MESSAGER, "Javac gave an IOException: " + e.getMessage());
                    return null;
                }
            }
            return result;
        }
        catch (IOException e) {
            this.logger.note(LogLocation.MESSAGER, "getResource gave an IOException: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharSequence tryWithReader(FileObject resource) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(resource.openReader(true));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            reader.close();
        }
        return sb;
    }
}

