/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.kordamp.jipsy.processor.AbstractPersistence;
import org.kordamp.jipsy.processor.DefaultResourceInitializer;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public abstract class AbstractResourcePersistence
extends AbstractPersistence {
    protected final Filer filer;

    public AbstractResourcePersistence(Filer filer, String name, Logger logger, String path) {
        super(name, logger, path);
        this.filer = filer;
    }

    @Override
    public Initializer getInitializer() {
        return new DefaultResourceInitializer(this.filer, this.path, this.logger);
    }

    @Override
    public File determineOutputLocation() {
        FileObject resource;
        try {
            resource = this.getResourceFile("locator");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            this.logger.note(LogLocation.MESSAGER, "IOException while determining output location: " + e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        URI uri = resource.toUri();
        if (uri.isAbsolute()) {
            return new File(uri).getParentFile();
        }
        return new File(uri.toString()).getParentFile();
    }

    @Override
    public void delete() throws IOException {
        this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path + this.name).delete();
    }

    protected FileObject getResourceFile(String name) throws IOException {
        return this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path + name);
    }

    protected FileObject createResourceFile(String name) throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.path + name, new Element[0]);
    }

    @Override
    protected Writer createWriter(String name) throws IOException {
        FileObject output = this.createResourceFile(name);
        return output.openWriter();
    }
}

