/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.kordamp.jipsy.processor.CheckResult;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;
import org.kordamp.jipsy.processor.Options;
import org.kordamp.jipsy.processor.ProcessorLogger;
import org.kordamp.jipsy.processor.service.ServiceProviderProcessor;

public abstract class AbstractSpiProcessor
extends AbstractProcessor {
    protected static final Pattern RELEASE_PATTERN = Pattern.compile("^RELEASE_(\\d+)$");
    protected Options options;
    protected Logger logger;

    @Override
    public synchronized void init(ProcessingEnvironment environment) {
        super.init(environment);
        try {
            this.initialize();
        }
        catch (Exception e) {
            environment.getMessager().printMessage(Diagnostic.Kind.ERROR, ProcessorLogger.exceptionToString(e));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.options.disabled()) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.logger.note(LogLocation.LOG_FILE, "Starting round with " + roundEnv.getRootElements().size() + " elements");
        this.removeStaleData(roundEnv);
        this.handleAnnotations(roundEnv);
        long end = System.currentTimeMillis();
        this.logger.note(LogLocation.LOG_FILE, "Ending round in " + (end - start) + " milliseconds");
        if (roundEnv.processingOver()) {
            this.writeData();
        }
        return false;
    }

    protected abstract Class<? extends Annotation> getAnnotationClass();

    protected abstract void handleElement(Element var1);

    protected abstract void removeStaleData(RoundEnvironment var1);

    protected abstract void writeData();

    protected void warning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }

    protected void initialize() {
        this.options = new Options(ServiceProviderProcessor.NAME, this.processingEnv.getOptions());
        if (this.options.disabled()) {
            return;
        }
        this.logger = new ProcessorLogger(this.processingEnv.getMessager(), this.options);
        this.checkCompatibility();
    }

    protected void checkCompatibility() {
        this.logger.note(LogLocation.MESSAGER, "Testing for compatibility options");
        try {
            this.checkJavacOnLinux();
        }
        catch (Exception e) {
            this.warning(ProcessorLogger.exceptionToString(e));
        }
        this.logger.note(LogLocation.MESSAGER, "Testing complete");
    }

    protected void checkJavacOnLinux() {
        try {
            FileObject resource = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.options.dir() + "a/b");
            if (resource.toUri().toString().equals("b")) {
                this.warning("Output files will be placed in the root of the output folder.\n  This is a known bug in the java compiler on Linux.\n  Please use the -d compiler option to circumvent this problem.\n  See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6647996 for more information.");
            }
        }
        catch (IOException e) {
            this.warning("IOException during testing Javac on Linux");
        }
    }

    protected void handleAnnotations(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(this.getAnnotationClass());
        for (Element element : elements) {
            this.handleElement(element);
        }
    }

    protected void reportError(TypeElement element, CheckResult result) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.getSimpleName() + " " + result.getMessage(), element);
    }

    protected boolean hasPublicNoArgsConstructor(TypeElement currentClass) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(currentClass.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            if (!this.hasModifier(constructor, Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasModifier(Element element, Modifier modifier) {
        return element.getModifiers().contains((Object)modifier);
    }

    protected boolean isStaticClass(TypeElement element) {
        return element.getEnclosingElement().getKind() != ElementKind.CLASS || this.hasModifier(element, Modifier.STATIC);
    }

    protected boolean isAbstractClass(TypeElement element) {
        return element.getEnclosingElement().getKind() == ElementKind.CLASS && this.hasModifier(element, Modifier.ABSTRACT);
    }

    protected CheckResult isImplementation(TypeElement currentClass, TypeElement type) {
        if (this.isAssignable(currentClass.asType(), type.asType())) {
            return CheckResult.OK;
        }
        String message = type.getKind() == ElementKind.INTERFACE ? "does not implement" : "does not extend";
        return CheckResult.valueOf(message + " " + type.getQualifiedName());
    }

    protected boolean isAssignable(TypeMirror currentClass, TypeMirror type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        if (typeUtils.isAssignable(typeUtils.erasure(currentClass), typeUtils.erasure(type))) {
            return true;
        }
        for (TypeMirror typeMirror : typeUtils.directSupertypes(currentClass)) {
            if (!this.isAssignable(typeMirror, type)) continue;
            return true;
        }
        return false;
    }

    protected AnnotationValue findSingleValueMember(AnnotationMirror mirror, String memberName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(memberName)) continue;
            return entry.getValue();
        }
        throw new IllegalStateException("No value found in element");
    }

    protected Collection<AnnotationValue> findCollectionValueMember(AnnotationMirror mirror, String memberName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(memberName)) continue;
            return (Collection)entry.getValue().getValue();
        }
        throw new IllegalStateException("No value found in element");
    }

    protected String createProperQualifiedName(TypeElement type) {
        return this.processingEnv.getElementUtils().getBinaryName(type).toString();
    }

    protected static List<AnnotationMirror> findAnnotationMirrors(TypeElement element, String lookingFor) {
        ArrayList<AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!AbstractSpiProcessor.annotationMirrorMatches(annotationMirror, lookingFor)) continue;
            annotationMirrors.add(annotationMirror);
        }
        return annotationMirrors;
    }

    protected static boolean annotationMirrorMatches(AnnotationMirror annotation, String lookingFor) {
        Name qualifiedName = ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName();
        return qualifiedName.contentEquals(lookingFor);
    }

    protected static TypeElement toElement(AnnotationValue value) {
        return (TypeElement)((DeclaredType)((TypeMirror)value.getValue())).asElement();
    }
}

