/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;
import org.kordamp.jipsy.processor.Options;

public final class ProcessorLogger
implements Logger {
    private final Messager messager;
    private final Options options;
    private final StringBuffer logContent = new StringBuffer();

    public ProcessorLogger(Messager messager, Options options) {
        if (messager == null) {
            throw new NullPointerException("messager");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.messager = messager;
        this.options = options;
        this.note(LogLocation.MESSAGER, options.report());
        for (String warning : options.getWarnings()) {
            this.warning(LogLocation.BOTH, warning);
        }
    }

    @Override
    public void note(LogLocation location, String message) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.options.verbose() && location.toMessager()) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, message);
        }
        if (this.options.logging() && location.toLogFile()) {
            this.logContent.append(message).append("\n");
        }
    }

    @Override
    public void warning(LogLocation location, String message) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (location.toMessager()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, message);
        }
        if (this.options.logging() && location.toLogFile()) {
            this.logContent.append("warning: ").append(message).append("\n");
        }
    }

    @Override
    public String getFileContent() {
        return this.logContent.toString();
    }

    public static String exceptionToString(Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        StringWriter out = new StringWriter();
        exception.printStackTrace(new PrintWriter(out));
        return out.toString();
    }
}

