/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;
import org.kordamp.jipsy.processor.service.Service;

public final class ServiceCollector {
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();
    private final Map<String, Service> cached = new LinkedHashMap<String, Service>();
    private final List<String> removed = new ArrayList<String>();
    private final Initializer initializer;
    private final Logger logger;

    public ServiceCollector(Initializer initializer, Logger logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    public void cache() {
        this.cached.putAll(this.services);
    }

    public boolean isModified() {
        if (this.cached.size() != this.services.size()) {
            return true;
        }
        for (Map.Entry<String, Service> e : this.cached.entrySet()) {
            if (!this.services.containsKey(e.getKey())) {
                return true;
            }
            if (e.getValue().equals(this.services.get(e.getKey()))) continue;
            return true;
        }
        return false;
    }

    public Service getService(String service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        if (!this.services.containsKey(service)) {
            Service newService = new Service(this.logger, service);
            CharSequence initialData = this.initializer.initialData(service);
            if (initialData != null) {
                newService.fromProviderNamesList(((Object)initialData).toString());
                for (String provider : this.removed) {
                    newService.removeProvider(provider);
                }
            }
            this.services.put(service, newService);
        }
        return this.services.get(service);
    }

    public Collection<Service> services() {
        return Collections.unmodifiableMap(this.services).values();
    }

    public void removeProvider(String provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.logger.note(LogLocation.LOG_FILE, "Removing " + provider);
        this.removed.add(provider);
        for (Service service : this.services.values()) {
            service.removeProvider(provider);
        }
    }

    public String toString() {
        return this.services.values().toString();
    }
}

