/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.processor.service;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.kordamp.jipsy.ServiceProviderFor;
import org.kordamp.jipsy.processor.AbstractSpiProcessor;
import org.kordamp.jipsy.processor.CheckResult;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Persistence;
import org.kordamp.jipsy.processor.service.Service;
import org.kordamp.jipsy.processor.service.ServiceCollector;
import org.kordamp.jipsy.processor.service.ServicePersistence;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"spi_dir", "spi_log", "spi_verbose", "spi_disabled"})
public class ServiceProviderProcessor
extends AbstractSpiProcessor {
    public static final String NAME = ServiceProviderProcessor.class.getName() + " (" + ServiceProviderProcessor.class.getPackage().getImplementationVersion() + ")";
    private static final int MAX_SUPPORTED_VERSION = 8;
    private Persistence persistence;
    private ServiceCollector data;

    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return ServiceProviderFor.class;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion[] svs = SourceVersion.values();
        for (int i = svs.length - 1; i >= 0; --i) {
            int release;
            String name = svs[i].name();
            Matcher m = RELEASE_PATTERN.matcher(name);
            if (!m.matches() || (release = Integer.parseInt(m.group(1))) > 8) continue;
            return svs[i];
        }
        return SourceVersion.RELEASE_6;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.persistence = new ServicePersistence(NAME, this.options.dir(), this.processingEnv.getFiler(), this.logger);
        this.data = new ServiceCollector(this.persistence.getInitializer(), this.logger);
        for (String serviceName : this.persistence.tryFind()) {
            this.data.getService(serviceName);
        }
        this.data.cache();
    }

    @Override
    protected void writeData() {
        if (this.data.isModified()) {
            if (this.data.services().isEmpty()) {
                this.logger.note(LogLocation.LOG_FILE, "Writing output");
                try {
                    this.persistence.delete();
                }
                catch (IOException e) {
                    this.logger.warning(LogLocation.LOG_FILE, "An error occurred while deleting data file");
                }
            } else {
                this.logger.note(LogLocation.LOG_FILE, "Writing output");
                for (Service service : this.data.services()) {
                    try {
                        this.persistence.write(service.getName(), service.toProviderNamesList());
                    }
                    catch (IOException e) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                    }
                }
                this.persistence.writeLog();
            }
        }
    }

    @Override
    protected void removeStaleData(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement currentClass = (TypeElement)element;
            this.data.removeProvider(this.createProperQualifiedName(currentClass));
        }
    }

    @Override
    protected void handleElement(Element e) {
        if (!(e instanceof TypeElement)) {
            return;
        }
        TypeElement currentClass = (TypeElement)e;
        CheckResult checkResult = this.checkCurrentClass(currentClass);
        if (checkResult.isError()) {
            this.reportError(currentClass, checkResult);
            return;
        }
        for (TypeElement service : this.findServices(currentClass)) {
            CheckResult implementationResult = this.isImplementation(currentClass, service);
            if (implementationResult.isError()) {
                this.reportError(currentClass, implementationResult);
                continue;
            }
            this.register(this.createProperQualifiedName(service), currentClass);
        }
    }

    private CheckResult checkCurrentClass(TypeElement currentClass) {
        if (currentClass.getKind() != ElementKind.CLASS) {
            return CheckResult.valueOf("is not a class");
        }
        if (!this.hasModifier(currentClass, Modifier.PUBLIC)) {
            return CheckResult.valueOf("is not a public class");
        }
        if (!this.isStaticClass(currentClass)) {
            return CheckResult.valueOf("is not a static class");
        }
        if (!this.hasPublicNoArgsConstructor(currentClass)) {
            return CheckResult.valueOf("has no public no-args constructor");
        }
        return CheckResult.OK;
    }

    private List<TypeElement> findServices(TypeElement classElement) {
        ArrayList<TypeElement> services = new ArrayList<TypeElement>();
        for (AnnotationMirror annotation : ServiceProviderProcessor.findAnnotationMirrors(classElement, this.getAnnotationClass().getName())) {
            for (AnnotationValue value : this.findCollectionValueMember(annotation, "value")) {
                services.add(ServiceProviderProcessor.toElement(value));
            }
        }
        return services;
    }

    private void register(String serviceName, TypeElement provider) {
        this.data.getService(serviceName).addProvider(this.createProperQualifiedName(provider));
    }
}

