/*
 * Decompiled with CFR 0.152.
 */
package griffon.builder.core;

import griffon.builder.core.factory.MetaComponentFactory;
import griffon.core.threading.UIThreadManager;
import groovy.lang.Closure;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.groovy.view.AbstractBuilderCustomizer;
import org.codehaus.groovy.runtime.MethodClosure;

@Named(value="core")
public class CoreBuilderCustomizer
extends AbstractBuilderCustomizer {
    private static final String KEY_ROOT_NODE_NAME = "ROOT_NODE_NAME";
    @Inject
    private UIThreadManager uiThreadManager;

    public CoreBuilderCustomizer() {
        LinkedHashMap<String, Factory> linkedHashMap = new LinkedHashMap<String, Factory>();
        linkedHashMap.put("metaComponent", (Factory)new MetaComponentFactory());
        this.setFactories(linkedHashMap);
    }

    @PostConstruct
    private void setup() {
        LinkedHashMap<String, Closure> linkedHashMap = new LinkedHashMap<String, Closure>();
        linkedHashMap.put("runInsideUISync", (Closure)new MethodClosure((Object)this.uiThreadManager, "runInsideUISync"));
        linkedHashMap.put("runInsideUIAsync", (Closure)new MethodClosure((Object)this.uiThreadManager, "runInsideUIAsync"));
        linkedHashMap.put("runOutsideUI", (Closure)new MethodClosure((Object)this.uiThreadManager, "runOutsideUI"));
        linkedHashMap.put("runFuture", (Closure)new MethodClosure((Object)this.uiThreadManager, "runFuture"));
        linkedHashMap.put("isUIThread", (Closure)new MethodClosure((Object)this.uiThreadManager, "isUIThread"));
        this.setMethods(linkedHashMap);
    }

    @Override
    @Nonnull
    public List<Closure> getPreInstantiateDelegates() {
        return Arrays.asList(new MethodClosure((Object)this, "rootNodePreInstantiateDelegate"));
    }

    @Override
    @Nonnull
    public List<Closure> getPostNodeCompletionDelegates() {
        return Arrays.asList(new MethodClosure((Object)this, "rootNodePostNodeCompletionDelegate"));
    }

    protected void rootNodePreInstantiateDelegate(FactoryBuilderSupport factoryBuilderSupport, Map map, Object object) {
        String string = String.valueOf(factoryBuilderSupport.getContext().get("_CURRENT_NAME_"));
        if (!factoryBuilderSupport.hasVariable(KEY_ROOT_NODE_NAME)) {
            factoryBuilderSupport.setVariable(KEY_ROOT_NODE_NAME, (Object)string);
        }
    }

    protected void rootNodePostNodeCompletionDelegate(FactoryBuilderSupport factoryBuilderSupport, Object object, Object object2) {
        String string = String.valueOf(factoryBuilderSupport.getContext().get("_CURRENT_NAME_"));
        if (factoryBuilderSupport.getVariable(KEY_ROOT_NODE_NAME).equals(string) && factoryBuilderSupport.hasVariable("mvcId")) {
            String string2 = String.valueOf(factoryBuilderSupport.getVariable("mvcId"));
            factoryBuilderSupport.getVariables().put(string2 + "-rootNode", object2);
        }
    }
}

