/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.util.FactoryBuilderSupport;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BindUtils {
    @Nonnull
    public static BindingBuilder binding() {
        return new BindingBuilder();
    }

    public static class BindingBuilder {
        private Object source;
        private Object target;
        private String sourceProperty;
        private String targetProperty;
        private CallableWithArgs<?> converter;
        private CallableWithArgs<?> validator;
        private boolean mutual;

        @Nonnull
        public BindingBuilder withSource(@Nullable Object object) {
            this.source = object;
            return this;
        }

        @Nonnull
        public BindingBuilder withTarget(@Nullable Object object) {
            this.target = object;
            return this;
        }

        @Nonnull
        public BindingBuilder withSourceProperty(@Nullable String string) {
            this.sourceProperty = string;
            return this;
        }

        @Nonnull
        public BindingBuilder withTargetProperty(@Nullable String string) {
            this.targetProperty = string;
            return this;
        }

        @Nonnull
        public BindingBuilder withConverter(@Nullable CallableWithArgs<?> callableWithArgs) {
            this.converter = callableWithArgs;
            return this;
        }

        @Nonnull
        public BindingBuilder withValidator(@Nullable CallableWithArgs<?> callableWithArgs) {
            this.validator = callableWithArgs;
            return this;
        }

        @Nonnull
        public BindingBuilder withMutual(boolean bl) {
            this.mutual = bl;
            return this;
        }

        public void make(@Nonnull FactoryBuilderSupport factoryBuilderSupport) {
            Objects.requireNonNull(factoryBuilderSupport, "Cannot make binding with a null builder!");
            Objects.requireNonNull(this.source, "Unspecified value for: source");
            Objects.requireNonNull(this.target, "Unspecified value for: target");
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (GriffonNameUtils.isBlank((String)this.sourceProperty)) {
                this.sourceProperty = this.targetProperty;
            }
            if (GriffonNameUtils.isBlank((String)this.sourceProperty)) {
                throw new IllegalArgumentException("Unspecified values for: sourceProperty, targetProperty");
            }
            if (GriffonNameUtils.isBlank((String)this.targetProperty)) {
                this.targetProperty = this.sourceProperty;
            }
            linkedHashMap.put("source", this.source);
            linkedHashMap.put("target", this.target);
            linkedHashMap.put("sourceProperty", this.sourceProperty);
            linkedHashMap.put("targetProperty", this.targetProperty);
            linkedHashMap.put("mutual", this.mutual);
            if (this.converter != null) {
                linkedHashMap.put("converter", this.makeClosure(factoryBuilderSupport, this.converter));
            }
            if (this.validator != null) {
                linkedHashMap.put("validator", this.makeClosure(factoryBuilderSupport, this.validator));
            }
            factoryBuilderSupport.invokeMethod("bind", linkedHashMap);
        }

        private Closure<?> makeClosure(@Nonnull FactoryBuilderSupport factoryBuilderSupport, final @Nonnull CallableWithArgs<?> callableWithArgs) {
            if (callableWithArgs instanceof Closure) {
                return (Closure)callableWithArgs;
            }
            return new Closure<Object>((Object)factoryBuilderSupport){
                private static final long serialVersionUID = -4108869890482462552L;

                public Object call(Object ... objectArray) {
                    return callableWithArgs.call(objectArray);
                }

                public Object call(Object object) {
                    return callableWithArgs.call(new Object[]{object});
                }
            };
        }
    }
}

