/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import groovy.util.IndentPrinter;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import groovy.util.slurpersupport.NodeChild;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Xml2Groovy {
    private static final Xml2Groovy INSTANCE = new Xml2Groovy();

    public static Xml2Groovy getInstance() {
        return INSTANCE;
    }

    private Xml2Groovy() {
    }

    public String parse(File file) {
        try {
            return this.translate(this.newXmlSlurper().parse(file));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String parse(InputSource inputSource) {
        try {
            return this.translate(this.newXmlSlurper().parse(inputSource));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String parse(InputStream inputStream) {
        try {
            return this.translate(this.newXmlSlurper().parse(inputStream));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String parse(Reader reader) {
        try {
            return this.translate(this.newXmlSlurper().parse(reader));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String parse(String string) {
        try {
            return this.translate(this.newXmlSlurper().parse(string));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String parse(GPathResult gPathResult) {
        return this.translate(gPathResult);
    }

    public String parseText(String string) {
        try {
            return this.translate(this.newXmlSlurper().parseText(string));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private XmlSlurper newXmlSlurper() {
        try {
            return new XmlSlurper();
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private String translate(GPathResult gPathResult) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IndentPrinter indentPrinter = this.createIndentPrinter(byteArrayOutputStream);
        this.walkXml(indentPrinter, (NodeChild)gPathResult);
        indentPrinter.flush();
        return byteArrayOutputStream.toString();
    }

    private IndentPrinter createIndentPrinter(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        return new IndentPrinter((Writer)printWriter, "    ");
    }

    private void walkXml(IndentPrinter indentPrinter, NodeChild nodeChild) {
        Iterator iterator;
        Object object;
        indentPrinter.printIndent();
        indentPrinter.print(nodeChild.name());
        if (!nodeChild.attributes().isEmpty()) {
            indentPrinter.print("(");
            object = new ArrayList();
            iterator = nodeChild.attributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                object.add(entry2.getKey() + ": " + entry2.getValue());
            }
            indentPrinter.print(DefaultGroovyMethods.join((Iterable)object, (String)", "));
            indentPrinter.print(")");
        }
        if (nodeChild.children().size() > 0) {
            indentPrinter.println(" {");
            indentPrinter.incrementIndent();
            object = nodeChild.childNodes();
            while (object.hasNext()) {
                iterator = object.next();
                if (iterator instanceof NodeChild) {
                    this.walkXml(indentPrinter, (NodeChild)iterator);
                    continue;
                }
                if (!(iterator instanceof Node)) continue;
                this.walkXml(indentPrinter, (Node)iterator);
            }
            indentPrinter.decrementIndent();
            indentPrinter.printIndent();
            indentPrinter.println("}");
        } else if (!nodeChild.attributes().isEmpty()) {
            indentPrinter.println("");
        } else {
            indentPrinter.println("()");
        }
    }

    private void walkXml(IndentPrinter indentPrinter, Node node) {
        Iterator iterator;
        Object object;
        indentPrinter.printIndent();
        indentPrinter.print(node.name());
        if (!node.attributes().isEmpty()) {
            indentPrinter.print("(");
            object = new ArrayList();
            iterator = node.attributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                object.add(entry2.getKey() + ": " + entry2.getValue());
            }
            indentPrinter.print(DefaultGroovyMethods.join((Iterable)object, (String)", "));
            indentPrinter.print(")");
        }
        if (node.children().size() > 0) {
            indentPrinter.println(" {");
            indentPrinter.incrementIndent();
            object = node.childNodes();
            while (object.hasNext()) {
                iterator = object.next();
                if (iterator instanceof NodeChild) {
                    this.walkXml(indentPrinter, (NodeChild)iterator);
                    continue;
                }
                if (!(iterator instanceof Node)) continue;
                this.walkXml(indentPrinter, (Node)iterator);
            }
            indentPrinter.decrementIndent();
            indentPrinter.printIndent();
            indentPrinter.println("}");
        } else if (!node.attributes().isEmpty()) {
            indentPrinter.println("");
        } else {
            indentPrinter.println("()");
        }
    }
}

