/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupConfiguration;
import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import org.codehaus.griffon.runtime.core.addon.AbstractGriffonAddon;

@Named(value="groovy")
public class GroovyAddon
extends AbstractGriffonAddon {
    private GriffonApplication application;

    public void init(@Nonnull GriffonApplication griffonApplication) {
        this.application = griffonApplication;
    }

    public void onInitializeMVCGroup(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nonnull MVCGroup mVCGroup) {
        GriffonController griffonController = mVCGroup.getController();
        if (griffonController == null) {
            return;
        }
        FactoryBuilderSupport factoryBuilderSupport = (FactoryBuilderSupport)mVCGroup.getMember("builder");
        if (factoryBuilderSupport == null) {
            return;
        }
        Map map = this.application.getActionManager().actionsFor(griffonController);
        for (Map.Entry entry : map.entrySet()) {
            String string = this.application.getActionManager().normalizeName((String)entry.getKey()) + "Action";
            this.getLog().trace("Adding action {} to {}:{}:builder", new Object[]{string, mVCGroupConfiguration.getMvcType(), mVCGroup.getMvcId()});
            factoryBuilderSupport.setVariable(string, ((Action)entry.getValue()).getToolkitAction());
        }
    }
}

