/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.mvc;

import griffon.core.ApplicationClassLoader;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.mvc.MVCGroup;
import griffon.util.AnnotationUtils;
import griffon.util.BuilderCustomizer;
import griffon.util.CompositeBuilder;
import groovy.util.FactoryBuilderSupport;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.mvc.DefaultMVCGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyAwareMVCGroupManager
extends DefaultMVCGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMVCGroupManager.class);
    private static final String BUILDER_CUSTOMIZER = "BuilderCustomizer";

    @Inject
    public GroovyAwareMVCGroupManager(@Nonnull GriffonApplication griffonApplication, @Nonnull ApplicationClassLoader applicationClassLoader) {
        super(griffonApplication, applicationClassLoader);
    }

    @Nonnull
    protected Map<String, Object> instantiateMembers(@Nonnull Map<String, DefaultMVCGroupManager.ClassHolder> map, @Nonnull Map<String, Object> map2) {
        Map map3 = super.instantiateMembers(map, map2);
        FactoryBuilderSupport factoryBuilderSupport = this.createBuilder(this.getApplication());
        map3.put("builder", factoryBuilderSupport);
        return map3;
    }

    @Nonnull
    protected FactoryBuilderSupport createBuilder(@Nonnull GriffonApplication griffonApplication) {
        Collection<BuilderCustomizer> collection = this.resolveBuilderCustomizers(griffonApplication);
        return new CompositeBuilder(collection.toArray(new BuilderCustomizer[collection.size()]));
    }

    protected void adjustMvcArguments(@Nonnull MVCGroup mVCGroup, @Nonnull Map<String, Object> map) {
        super.adjustMvcArguments(mVCGroup, map);
        FactoryBuilderSupport factoryBuilderSupport = (FactoryBuilderSupport)mVCGroup.getMember("builder");
        map.put("builder", factoryBuilderSupport);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            factoryBuilderSupport.setVariable(entry.getKey(), entry.getValue());
        }
    }

    protected void initializeMembers(@Nonnull MVCGroup mVCGroup, @Nonnull Map<String, Object> map) {
        FactoryBuilderSupport factoryBuilderSupport = (FactoryBuilderSupport)mVCGroup.getMember("builder");
        factoryBuilderSupport.setVariable("_CURRENT_MVCGROUP_", (Object)mVCGroup);
        super.initializeMembers(mVCGroup, map);
    }

    protected void destroyMembers(@Nonnull MVCGroup mVCGroup, boolean bl) {
        super.destroyMembers(mVCGroup, bl);
        try {
            FactoryBuilderSupport factoryBuilderSupport = (FactoryBuilderSupport)mVCGroup.getMember("builder");
            if (factoryBuilderSupport != null) {
                factoryBuilderSupport.dispose();
                factoryBuilderSupport.getVariables().clear();
            }
        }
        catch (Exception exception) {
            LOG.error("Application encountered an error while destroying group '" + mVCGroup.getMvcId() + "'", GriffonExceptionHandler.sanitize((Throwable)exception));
        }
    }

    @Nonnull
    protected Collection<BuilderCustomizer> resolveBuilderCustomizers(@Nonnull GriffonApplication griffonApplication) {
        Collection collection = griffonApplication.getInjector().getInstances(BuilderCustomizer.class);
        return AnnotationUtils.sortByDependencies((Collection)collection, (String)BUILDER_CUSTOMIZER, (String)"customizer").values();
    }
}

