/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.util;

import griffon.core.resources.ResourceHandler;
import griffon.util.ConfigReader;
import groovy.lang.Script;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.groovy.util.GroovyScriptResourceBundle;
import org.codehaus.griffon.runtime.util.DefaultCompositeResourceBundleBuilder;

public class GroovyAwareCompositeResourceBundleBuilder
extends DefaultCompositeResourceBundleBuilder {
    protected static final String GROOVY_SUFFIX = ".groovy";
    private final ConfigReader configReader;

    @Inject
    public GroovyAwareCompositeResourceBundleBuilder(@Nonnull ResourceHandler resourceHandler, @Nonnull ConfigReader configReader) {
        super(resourceHandler);
        this.configReader = Objects.requireNonNull(configReader, "Argument 'reader' must not be null");
    }

    @Nonnull
    protected Collection<ResourceBundle> loadBundleFromClass(@Nonnull String string) {
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        URL uRL = this.getResourceAsURL(string, GROOVY_SUFFIX);
        if (null != uRL) {
            arrayList.add(new GroovyScriptResourceBundle(this.configReader, uRL));
            return arrayList;
        }
        uRL = this.getResourceAsURL(string, ".class");
        if (null != uRL) {
            String string2 = string.replace('/', '.');
            try {
                Class clazz = this.loadClass(string2);
                if (Script.class.isAssignableFrom(clazz)) {
                    arrayList.add(new GroovyScriptResourceBundle(this.configReader, clazz));
                    return arrayList;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadBundleFromClass(string);
    }
}

