/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.util;

import griffon.util.ConfigReader;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroovyScriptResourceBundle
extends ResourceBundle {
    private static final String ERROR_READER_NULL = "Argument 'reader' must not be null";
    private final ConfigObject config;
    private final Set<String> keys = new LinkedHashSet<String>();
    private final String source;

    public GroovyScriptResourceBundle(@Nonnull ConfigReader configReader, @Nonnull URL uRL) {
        this(Objects.requireNonNull(configReader, ERROR_READER_NULL).parse(Objects.requireNonNull(uRL, "Argument 'location' must not be null")), uRL.toString());
    }

    public GroovyScriptResourceBundle(@Nonnull ConfigReader configReader, @Nonnull Script script) {
        this(Objects.requireNonNull(configReader, ERROR_READER_NULL).parse(Objects.requireNonNull(script, "Argument 'script' must not be null")), script.getClass().getName());
    }

    public GroovyScriptResourceBundle(@Nonnull ConfigReader configReader, @Nonnull String string) {
        this(Objects.requireNonNull(configReader, ERROR_READER_NULL).parse(GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'script' must not be blank")), "<<INLINE SCRIPT>>");
    }

    public GroovyScriptResourceBundle(@Nonnull ConfigReader configReader, @Nonnull Class<? extends Script> clazz) {
        this(Objects.requireNonNull(configReader, ERROR_READER_NULL).parse(Objects.requireNonNull(clazz, "Argument 'scriptClass' must not be null")), clazz.getName());
    }

    private GroovyScriptResourceBundle(@Nonnull ConfigObject configObject, @Nonnull String string) {
        this.config = Objects.requireNonNull(configObject, "Argument 'config' must not be null");
        this.source = string;
        this.keys.addAll(this.config.flatten(new LinkedHashMap()).keySet());
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    public String toString() {
        return super.toString() + "[" + this.source + "]";
    }

    @Override
    @Nullable
    protected Object handleGetObject(@Nonnull String string) {
        Object object = ConfigUtils.getConfigValue((Map)this.config, (String)GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'key' must not be blank"), null);
        if (null == object) {
            return null;
        }
        if (object instanceof ConfigObject) {
            return ((ConfigObject)object).isEmpty() ? null : object;
        }
        return object;
    }

    @Override
    @Nonnull
    public Enumeration<String> getKeys() {
        final Iterator<String> iterator = this.keys.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.keys);
    }
}

