/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core;

import java.lang.reflect.Modifier;

public class MethodDescriptor {
    private static final TypeParam[] EMPTY_PARAMETERS = new TypeParam[0];
    private static final Type[] EMPTY_TYPES = new Type[0];
    private static final Type NO_BOUND = new Type("_");
    public final int modifiers;
    public final String methodName;
    public final Type returnType;
    public final TypeParam[] typeParameters;
    public final Type[] annotations;
    public final Type[] exceptions;
    public final Type[] arguments;
    public final String signature;

    public MethodDescriptor(Type type, TypeParam[] typeParamArray, String string, Type[] typeArray, Type[] typeArray2) {
        this(1, type, typeParamArray, string, typeArray, typeArray2, EMPTY_TYPES);
    }

    public MethodDescriptor(Type type, TypeParam[] typeParamArray, String string, Type[] typeArray, Type[] typeArray2, Type[] typeArray3) {
        this(1, type, typeParamArray, string, typeArray, typeArray2, typeArray3);
    }

    public MethodDescriptor(int n, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray, Type[] typeArray2) {
        this(n, type, typeParamArray, string, typeArray, typeArray2, EMPTY_TYPES);
    }

    public MethodDescriptor(int n, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray, Type[] typeArray2, Type[] typeArray3) {
        this.modifiers = n;
        this.returnType = type;
        this.methodName = string;
        this.typeParameters = typeParamArray != null ? typeParamArray : EMPTY_PARAMETERS;
        this.arguments = typeArray != null ? typeArray : EMPTY_TYPES;
        this.exceptions = typeArray2 != null ? typeArray2 : EMPTY_TYPES;
        this.annotations = typeArray3 != null ? typeArray3 : EMPTY_TYPES;
        this.signature = this.createMethodSignature();
    }

    public String toString() {
        return this.signature;
    }

    private String createMethodSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type : this.annotations) {
            stringBuilder.append("@").append(type.signature()).append(" ");
        }
        stringBuilder.append(Modifier.toString(this.modifiers)).append(" ");
        if (this.typeParameters.length > 0) {
            stringBuilder.append("<");
            for (int i = 0; i < this.typeParameters.length; ++i) {
                stringBuilder.append(this.typeParameters[i].signature);
                if (i >= this.typeParameters.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("> ");
        }
        stringBuilder.append(this.returnType.signature()).append(" ").append(this.methodName).append("(");
        if (this.arguments.length > 0) {
            for (int i = 0; i < this.arguments.length; ++i) {
                stringBuilder.append(this.arguments[i].signature()).append(" arg").append(i);
                if (i >= this.arguments.length - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(")");
        if (this.exceptions.length > 0) {
            stringBuilder.append(" throws ");
            for (int i = 0; i < this.exceptions.length; ++i) {
                stringBuilder.append(this.exceptions[i].signature());
                if (i >= this.exceptions.length - 1) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    public static Wildcard wildcard(String ... stringArray) {
        return new Wildcard(MethodDescriptor.types(stringArray));
    }

    public static Wildcard wildcardWithParams(Type ... typeArray) {
        return new Wildcard(typeArray);
    }

    public static Type annotation(String string) {
        return new Type(string);
    }

    public static Type[] annotations(String ... stringArray) {
        Type[] typeArray = new Type[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            typeArray[i] = MethodDescriptor.annotation(stringArray[i]);
        }
        return typeArray;
    }

    public static Type type(String string, String ... stringArray) {
        return new Type(string, MethodDescriptor.types(stringArray));
    }

    public static Type type(String string, int n, String ... stringArray) {
        return new Type(string, n, MethodDescriptor.types(stringArray));
    }

    public static Type annotatedType(Type[] typeArray, String string, String ... stringArray) {
        return new Type(typeArray, string, MethodDescriptor.types(stringArray));
    }

    public static Type annotatedType(Type[] typeArray, String string, int n, String ... stringArray) {
        return new Type(typeArray, string, n, MethodDescriptor.types(stringArray));
    }

    public static Type typeWithParams(String string, Type ... typeArray) {
        return new Type(string, typeArray);
    }

    public static Type typeWithParams(String string, int n, Type ... typeArray) {
        return new Type(string, n, typeArray);
    }

    public static Type typeWithParams(Type[] typeArray, String string, Type ... typeArray2) {
        return new Type(typeArray, string, typeArray2);
    }

    public static Type typeWithParams(Type[] typeArray, String string, int n, Type ... typeArray2) {
        return new Type(typeArray, string, n, typeArray2);
    }

    public static TypeParam[] typeParams(String ... stringArray) {
        TypeParam[] typeParamArray = new TypeParam[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            typeParamArray[i] = new TypeParam(stringArray[i]);
        }
        return typeParamArray;
    }

    public static TypeParam[] typeParams(TypeParam ... typeParamArray) {
        return typeParamArray;
    }

    public static TypeParam typeParam(String string) {
        return new TypeParam(string);
    }

    public static TypeParam typeParam(String string, String string2) {
        return new TypeParam(string, MethodDescriptor.type(string2, new String[0]));
    }

    public static TypeParam typeParam(String string, Type type) {
        return new TypeParam(string, type);
    }

    public static Type[] types(String ... stringArray) {
        Type[] typeArray = new Type[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            typeArray[i] = MethodDescriptor.type(stringArray[i], new String[0]);
        }
        return typeArray;
    }

    public static Type[] types(Type ... typeArray) {
        return typeArray;
    }

    public static Type[] args(Type ... typeArray) {
        return typeArray;
    }

    public static Type[] throwing(Type ... typeArray) {
        return typeArray;
    }

    public static MethodDescriptor method(Type type, TypeParam[] typeParamArray, String string, Type[] typeArray) {
        return new MethodDescriptor(type, typeParamArray, string, typeArray, EMPTY_TYPES);
    }

    public static MethodDescriptor method(Type type, TypeParam[] typeParamArray, String string) {
        return new MethodDescriptor(type, typeParamArray, string, EMPTY_TYPES, EMPTY_TYPES);
    }

    public static MethodDescriptor method(Type type, String string, Type[] typeArray) {
        return new MethodDescriptor(type, EMPTY_PARAMETERS, string, typeArray, EMPTY_TYPES);
    }

    public static MethodDescriptor method(Type type, String string) {
        return new MethodDescriptor(type, EMPTY_PARAMETERS, string, EMPTY_TYPES, EMPTY_TYPES);
    }

    public static MethodDescriptor method(Type type, TypeParam[] typeParamArray, String string, Type[] typeArray, Type[] typeArray2) {
        return new MethodDescriptor(type, typeParamArray, string, typeArray, typeArray2);
    }

    public static MethodDescriptor method(Type type, String string, Type[] typeArray, Type[] typeArray2) {
        return new MethodDescriptor(type, EMPTY_PARAMETERS, string, typeArray, typeArray2);
    }

    public static MethodDescriptor method(int n, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray) {
        return new MethodDescriptor(n, type, typeParamArray, string, typeArray, EMPTY_TYPES);
    }

    public static MethodDescriptor method(int n, Type type, TypeParam[] typeParamArray, String string) {
        return new MethodDescriptor(n, type, typeParamArray, string, EMPTY_TYPES, EMPTY_TYPES);
    }

    public static MethodDescriptor method(int n, Type type, String string, Type[] typeArray) {
        return new MethodDescriptor(n, type, EMPTY_PARAMETERS, string, typeArray, EMPTY_TYPES);
    }

    public static MethodDescriptor method(int n, Type type, String string) {
        return new MethodDescriptor(n, type, EMPTY_PARAMETERS, string, EMPTY_TYPES, EMPTY_TYPES);
    }

    public static MethodDescriptor method(int n, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray, Type[] typeArray2) {
        return new MethodDescriptor(n, type, typeParamArray, string, typeArray, typeArray2);
    }

    public static MethodDescriptor method(int n, Type type, String string, Type[] typeArray, Type[] typeArray2) {
        return new MethodDescriptor(n, type, EMPTY_PARAMETERS, string, typeArray, typeArray2);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray2) {
        return new MethodDescriptor(type, typeParamArray, string, typeArray2, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, Type type, TypeParam[] typeParamArray, String string) {
        return new MethodDescriptor(type, typeParamArray, string, EMPTY_TYPES, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, Type type, String string, Type[] typeArray2) {
        return new MethodDescriptor(type, EMPTY_PARAMETERS, string, typeArray2, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, Type type, String string) {
        return new MethodDescriptor(type, EMPTY_PARAMETERS, string, EMPTY_TYPES, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray2, Type[] typeArray3) {
        return new MethodDescriptor(type, typeParamArray, string, typeArray2, typeArray3, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, Type type, String string, Type[] typeArray2, Type[] typeArray3) {
        return new MethodDescriptor(type, EMPTY_PARAMETERS, string, typeArray2, typeArray3, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, int n, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray2) {
        return new MethodDescriptor(n, type, typeParamArray, string, typeArray2, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, int n, Type type, TypeParam[] typeParamArray, String string) {
        return new MethodDescriptor(n, type, typeParamArray, string, EMPTY_TYPES, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, int n, Type type, String string, Type[] typeArray2) {
        return new MethodDescriptor(n, type, EMPTY_PARAMETERS, string, typeArray2, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, int n, Type type, String string) {
        return new MethodDescriptor(n, type, EMPTY_PARAMETERS, string, EMPTY_TYPES, EMPTY_TYPES, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, int n, Type type, TypeParam[] typeParamArray, String string, Type[] typeArray2, Type[] typeArray3) {
        return new MethodDescriptor(n, type, typeParamArray, string, typeArray2, typeArray3, typeArray);
    }

    public static MethodDescriptor annotatedMethod(Type[] typeArray, int n, Type type, String string, Type[] typeArray2, Type[] typeArray3) {
        return new MethodDescriptor(n, type, EMPTY_PARAMETERS, string, typeArray2, typeArray3, typeArray);
    }

    public static class TypeParam {
        public final String type;
        public final Type bound;
        public final String signature;

        public TypeParam(String string) {
            this(string, NO_BOUND);
        }

        public TypeParam(String string, Type type) {
            this.type = string;
            this.bound = type != null ? type : NO_BOUND;
            this.signature = this.createTypeParamSignature();
        }

        public boolean isBound() {
            return this.bound != NO_BOUND;
        }

        private String createTypeParamSignature() {
            StringBuilder stringBuilder = new StringBuilder(this.type);
            if (this.bound != NO_BOUND) {
                stringBuilder.append(" extends ").append(this.bound.signature());
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.signature;
        }
    }

    public static class Wildcard
    extends Type {
        public static final String EXTENDS = "extends";
        public static final String SUPER = "super";
        public static final String NONE = "_";
        public final String bound;

        public Wildcard() {
            this(NONE, EMPTY_TYPES);
        }

        public Wildcard(Type[] typeArray) {
            this(EXTENDS, typeArray);
        }

        public Wildcard(String string, Type[] typeArray) {
            super("?", typeArray);
            this.bound = string;
        }

        public boolean isExtends() {
            return EXTENDS.equals(this.bound);
        }

        public boolean isSuper() {
            return SUPER.equals(this.bound);
        }

        @Override
        protected String createTypeSignature() {
            StringBuilder stringBuilder = new StringBuilder(this.type);
            if (this.parameters.length > 0) {
                stringBuilder.append(" ").append(this.bound).append(" ");
                for (int i = 0; i < this.parameters.length; ++i) {
                    stringBuilder.append(this.parameters[i].signature());
                    if (i >= this.parameters.length - 1) continue;
                    stringBuilder.append(", ");
                }
            }
            return stringBuilder.toString();
        }
    }

    public static class Type {
        public final String type;
        public final Type[] parameters;
        public final Type[] annotations;
        public final int dimensions;
        public String signature;

        public Type(String string) {
            this(EMPTY_TYPES, string, 0, EMPTY_TYPES);
        }

        public Type(String string, int n) {
            this(EMPTY_TYPES, string, n, EMPTY_TYPES);
        }

        public Type(String string, Type[] typeArray) {
            this(EMPTY_TYPES, string, 0, typeArray);
        }

        public Type(String string, int n, Type[] typeArray) {
            this(EMPTY_TYPES, string, n, typeArray);
        }

        public Type(Type[] typeArray, String string) {
            this(typeArray, string, 0, EMPTY_TYPES);
        }

        public Type(Type[] typeArray, String string, int n) {
            this(typeArray, string, n, EMPTY_TYPES);
        }

        public Type(Type[] typeArray, String string, Type[] typeArray2) {
            this(typeArray, string, 0, typeArray2);
        }

        public Type(Type[] typeArray, String string, int n, Type[] typeArray2) {
            this.type = string;
            this.dimensions = n;
            this.parameters = typeArray2 != null ? typeArray2 : EMPTY_TYPES;
            this.annotations = typeArray != null ? typeArray : EMPTY_TYPES;
        }

        public String signature() {
            if (this.signature == null) {
                this.signature = this.createTypeSignature();
            }
            return this.signature;
        }

        protected String createTypeSignature() {
            StringBuilder stringBuilder = new StringBuilder("");
            for (Type type : this.annotations) {
                stringBuilder.append("@").append(type.signature()).append(" ");
            }
            stringBuilder.append(this.type);
            if (this.parameters.length > 0) {
                stringBuilder.append("<");
                for (int i = 0; i < this.parameters.length; ++i) {
                    stringBuilder.append(this.parameters[i].signature());
                    if (i >= this.parameters.length - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(">");
            }
            for (int i = 0; i < this.dimensions; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.signature();
        }
    }
}

